/********** MOP03File.h ***********************************************************************************************\

 REVISION HISTORY
   11/02  Debbie Mao
   01/03  Debbie Mao -- change the mop03 file from Grid to Swath
   03/04  Debbie Mao -- change the mop03 file from Swath back to pure grid
   06/04  Debbie Mao -- change surfind from [DAY][NLAT][NLON] to [NLAT][NLON]
   03/05  Debbie Mao -- change surfind from [NLAT][NLON] back to [DAY][NLAT][NLON]
   08/16  Debbie Mao -- add function to write out TotalColumnAveragingKernel [DAY][NLAT][NLON][Prs1]

\**********************************************************************************************************************/

#if !defined _MOPITT_L3_MOP03_FILE_

  #define _MOPITT_L3_MOP03_FILE_

  #include "Driver.h"
  #include <string>

  using namespace std;

  class mop03_file  {
    private :

      string name;
      hid_t  fileid;
      hid_t  gdid;
      int32  metadataid;

    protected :

      int  defFieldG  ( string, string, string );
      int  defFieldI  ( string, string, string, string);
      int  defFieldF  ( string, string, string, string);
      int  defFieldF3 ( string, string, string, string, int);
      int  defFieldF4 ( string, string, string, string);

      int  wrField2I  ( string, int [XDim][YDim] );
      int  wrField2F  ( string, float [XDim][YDim] );
      int  wrField3   ( string, float [XDim][YDim][Prs] );
      int  wrField3F  ( string, float [XDim][YDim][NTWO] );
      int  wrField3P  ( string, float [XDim][YDim][Prs1] );
      int  wrField4   ( string, float [XDim][YDim][Prs1][Prs2] );

      bool Initialize ();

    public :
      mop03_file ( );
      ~mop03_file ();

      int32 GetMetadataID () const {return metadataid;}
      void  Close (double , double);

      void Write ( Product );
  };

#endif
