/********** QAFlags.C *************************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "QAFlags.h"

qa_flags :: qa_flags ()
          : attribute_group ()
{
  automaticqualityflagexplanation   [0] = '\0';
  automaticqualityflag              [0] = '\0';
  operationalqualityflagexplanation [0] = '\0';
  operationalqualityflag            [0] = '\0';
}


qa_flags :: ~qa_flags ()
{
  ;
}


bool qa_flags :: Set (PGSt_MET_handle handle, int parameternumber)
{
  bool isset = false;

  // set the flags
  (void) strcpy (automaticqualityflagexplanation, 
                 "Process Terminated Normally");
  (void) strcpy (automaticqualityflag, "Passed");
  (void) strcpy (operationalqualityflagexplanation,
                 "Process Terminated Normally");
  (void) strcpy (operationalqualityflag, "Unknown");

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr;
  char attributename [50];

  sptr = automaticqualityflagexplanation;
  (void) sprintf (attributename, "AutomaticQualityFlagExplanation.%d", parameternumber);
  if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

    sptr = automaticqualityflag;
    (void) sprintf (attributename, "AutomaticQualityFlag.%d", parameternumber);
    if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

      sptr = operationalqualityflagexplanation;
      (void) sprintf (attributename, "OperationalQualityFlagExplanation.%d", parameternumber);
      if (attribute_group::Set (handle, attributename, (void*) &sptr)) {

        sptr = operationalqualityflag;
        (void) sprintf (attributename, "OperationalQualityFlag.%d", parameternumber);
        if (attribute_group::Set (handle, attributename, (void*) &sptr))
          isset = true;
      }
    }
  }

  return isset;
}
