/********** MeasuredParameter.C ***************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao

 $Log$

\**********************************************************************************************************************/
#include "MeasuredParameter.h"
#include "Driver.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

measured_parameter :: measured_parameter ()
                    : attribute_group ()
{
  parametername [0] = '\0';
}


measured_parameter :: ~measured_parameter ()
{
  ;
}


bool measured_parameter :: Set (PGSt_MET_handle handle, string const& name, int parameternumber )
{
  bool isset = false;

  // get attr from MOP02 file
  int qamissing, qaoutofbounds, qacloudcover;
  if ( PGS_MET_GetPCAttr ( M2LOGICAL, 1, "coremetadata.0", "QAPercentMissingData.1", &qamissing) !=
       PGS_S_SUCCESS )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 840, "Could not get QAPercentMissingData.1");
  if ( PGS_MET_GetPCAttr ( M2LOGICAL, 1, "coremetadata.0", "QAPercentOutofBoundsData.1", &qaoutofbounds) !=
       PGS_S_SUCCESS )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 842, "Could not get QAPercentOutofBoundsDat.1");
  if ( PGS_MET_GetPCAttr ( M2LOGICAL, 1, "coremetadata.0", "QAPercentCloudCover.1", &qacloudcover) !=
       PGS_S_SUCCESS )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 844, "Could not get QAPercentCloudCover.1");

  // save the measured parameter name
  (void) strcpy (parametername, name.c_str ());

  // store the value
  char attributename [20];
  (void) sprintf (attributename, "ParameterName.%d", parameternumber);
  char *sptr = parametername;

  // set the attribute name, qa flags and qa stats
  if (attribute_group::Set (handle, attributename, (void*) &sptr))
    if (qaflags.Set (handle, parameternumber))
      if (qastats.Set (handle, parameternumber, qamissing, qaoutofbounds, qacloudcover))
        isset = true;

  return isset;
}
