/************************ GetMaj_PsurfInd.C *************************************************************************\

 PURPOSE
   To get majority psurf isurf at ilat/ilon

 REVISION HISTORY
   12/02   Debbie Mao
   11/07   Debbie Mao
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "Driver.h"
#include "MOP02.h"
#include <stdlib.h>


void GetMaj_PsurfInd (MOP02_Num Num, float psurfmaj [DAY][XDim][YDim], int isurf[DAY][XDim][YDim])
{
  int d, i, j;
  float tni, rni0, rni1;

  // initialize psurf and isurf
  for ( d = 0; d < DAY; d++ ) 
    for ( i = 0; i < XDim; i++ )
      for ( j = 0; j < YDim; j++ ) {
	psurfmaj [d][i][j] = MISSING_VALUE;
	isurf[d][i][j] = MISSING_INT;
      }

  // find out the dominate surface presure & surface index for each grid
  for ( d = 0; d < DAY; d++ ) 
    for ( i = 0; i < XDim; i++ ) 
      for ( j = 0; j < YDim; j++ ) {

	tni = 0.0;
	rni0 = 0.0;
	rni1 = 0.0;

	// get majority sureface presure, only mean valid levels for lat/lon grid
	if ( (Num.np10[d][i][j]>=Num.np6[d][i][j]) && (Num.np10[d][i][j]>=Num.np7[d][i][j]) && 
	     (Num.np10[d][i][j]>=Num.np8[d][i][j]) && (Num.np10[d][i][j]>=Num.np9[d][i][j]) )
	  psurfmaj[d][i][j] = PSURF900;

	else if ( (Num.np9[d][i][j]>=Num.np6[d][i][j]) && (Num.np9[d][i][j]>=Num.np7[d][i][j]) && 
		  (Num.np9[d][i][j]>=Num.np8[d][i][j]) && (Num.np9[d][i][j]>=Num.np10[d][i][j]) )
	  psurfmaj[d][i][j] = PSURF800;

	else if ( (Num.np8[d][i][j]>=Num.np6[d][i][j]) && (Num.np8[d][i][j]>=Num.np7[d][i][j]) && 
		  (Num.np8[d][i][j]>=Num.np9[d][i][j]) && (Num.np8[d][i][j]>=Num.np10[d][i][j]) )
	  psurfmaj[d][i][j] = PSURF700;

	else if ( (Num.np7[d][i][j]>=Num.np6[d][i][j]) && (Num.np7[d][i][j]>=Num.np8[d][i][j]) && 
		  (Num.np7[d][i][j]>=Num.np9[d][i][j]) && (Num.np7[d][i][j]>=Num.np10[d][i][j]) )
	  psurfmaj[d][i][j] = PSURF600;

	else if ( (Num.np6[d][i][j]>=Num.np7[d][i][j]) && (Num.np6[d][i][j]>=Num.np8[d][i][j]) && 
		  (Num.np6[d][i][j]>=Num.np9[d][i][j]) && (Num.np6[d][i][j]>=Num.np10[d][i][j]) )
	  psurfmaj[d][i][j] = PSURF500;


	// get final majority surface index (>= INDEXLIMIT) for lat/lon grid
	tni= Num.ni0[d][i][j] + Num.ni1[d][i][j] + Num.ni2[d][i][j];
	
	if ( tni > 0 ) {
	  rni0 = Num.ni0[d][i][j] / tni * 100.0;
	  rni1 = Num.ni1[d][i][j] / tni * 100.0;

	  if (rni0 >= INDEXLIMIT)
	    isurf[d][i][j] = 0;
	  else if (rni1 >= INDEXLIMIT)
	    isurf[d][i][j] = 1;
	  else 
	    isurf[d][i][j] = 2;
	}
      }
}
