/********** Drivers.h *************************************************************************************************\

 REVISION HISTORY
   11/02   Debbie Mao
   01/03   Debbie Mao -- change the mop03 file from Grid to Swath
   03/05   Debbie Mao
   02/09   Debbie Mao -- get final changes for MOPITT V4 release

\**********************************************************************************************************************/

#if !defined _MOPITT_L3_DRIVER_

  #include <stdio.h>
  #include <stdlib.h>
  #include <string>
  #include <math.h>
  #include "PGS_PC.h"
  #include "PGS_IO.h"
  #include "mfhdf.h"
  #include "HdfEosDef.h"
  #include "HE5_HdfEosDef.h"


  #define _MOPITT_L3_DRIVER_

  int const NTWO                = 2;
  int const NTHREE              = 3;
  int const NRES                = 12;                            // 7A,3A,1A,5A,7D,3D,1D,5D,2A,6A,2D,6D
  int const NTIME               = 290000;                        // ~ 6350 tracks * 29 stares * 4 pixels * 54%
  int const HTIME               = 145000;                        // ~ 6350 tracks * 29 stares * 4 pixels * 54%
  int const XDim                = 360;
  int const YDim                = 180;
  int const XBIN                = 1;
  int const YBIN                = 1;
  int const NIGHT               = 80;
  int const DAY                 = 2;                             // 0--DAY TIME; 1--NIGHT TIME
  int const Prs                 = 9;                             // MOP02 retrival levels
  int const Prs1                = 10;                            // standard retrieval levels for matrix field dim list
  int const Prs2                = 10;                            // standard retrieval levels
  int const NLIMIT              = 1;
  int const NPIXEL              = 4;

  int const M2LOGICAL           = 43000;
  int const RMPIXEL             = 43101;
  int const M3QELOGICAL         = 43997;
  int const M3LOGICAL           = 44000;
  int const MOP03_MCF_LOGICAL   = 44001;

  int const MISSING_INT         = -9999;
  int const INVENTORYMETADATA   = 1;

  float const MISSING_VALUE     = -9999.0;
  float const AVGKER_MIN        = -0.5;
  float const AVGKER_MAX        = 0.8;
  float const COLIMIT           = 0.0;
  float const WLIMIT            = 0.0;
  float const INDEXLIMIT        = 75.0;
  float const LOG10E            = 0.4342944819;
  float const PSURF900          = 901.0;
  float const PSURF800          = 801.0;
  float const PSURF700          = 701.0;
  float const PSURF600          = 601.0;
  float const PSURF500          = 501.0;

  struct MOP02_Geo {
    int timecount;
    float lat[NTIME];
    float lon[NTIME];
    float solzen[NTIME];
    float presurf[NTIME];
    int   indsurf[NTIME];
  };

  struct MOP02_Dat1 {
    float satzen[NTIME];
    float co_diag[NTIME][NTWO];
    float aker[NTIME][Prs1][Prs2];
    float ap_tsurf[NTIME];
    float ap_esurf[NTIME];
    float ap_comix[NTIME][Prs];
    float ap_cosurf[NTIME];
    float ap_cotot[NTIME];
    float dfs[NTIME];
    int   swInd[NTIME][NTHREE];
    float L1rad[NTIME][NRES][NTWO];
    float dryair_col[NTIME];
    float watervap_col[NTIME];
    float ak_tot[NTIME][Prs1];
    float measure_cov[NTIME][Prs1][Prs2];
    float smooth_cov[NTIME][Prs1][Prs2];
    float retrival_cov[NTIME][Prs1][Prs2];
  };

  struct MOP02_Dat2 {
    float tsurf[NTIME][NTWO];
    float esurf[NTIME][NTWO];
    float comix[NTIME][Prs][NTWO];
    float cosurf[NTIME][NTWO];
    float cotot[NTIME][NTWO];
    float demalt[NTIME];
    float chi2[NTIME];
  };

  struct MOP02_Num {
    int ni0[DAY][XDim][YDim]; 
    int ni1[DAY][XDim][YDim];
    int ni2[DAY][XDim][YDim];
    int np6[DAY][XDim][YDim];
    int np7[DAY][XDim][YDim];
    int np8[DAY][XDim][YDim];
    int np9[DAY][XDim][YDim];
    int np10[DAY][XDim][YDim];
  };

  struct MOP03_Num {
    int nzensol[DAY][XDim][YDim];
    int nzensat[DAY][XDim][YDim];
    int npsurf[DAY][XDim][YDim];
    int ntsurf[DAY][NTWO][XDim][YDim];
    int nesurf[DAY][NTWO][XDim][YDim];
    int nco_mix[DAY][XDim][YDim][Prs]; 
    int nco_surf[DAY][XDim][YDim];
    int nco_totmp[DAY][NTWO][XDim][YDim];
    int nco_diag[DAY][XDim][YDim][NTWO];
    int navgker[DAY][XDim][YDim][Prs1][Prs2]; 
    int nap_tsurf[DAY][XDim][YDim];
    int nap_esurf[DAY][XDim][YDim];
    int nap_co_mix[DAY][XDim][YDim][Prs]; 
    int nap_co_surf[DAY][XDim][YDim];
    int nap_co_tot[DAY][XDim][YDim];
    int nDFS[DAY][XDim][YDim];
    int nalt[DAY][XDim][YDim];
    int nchi[DAY][XDim][YDim];
    int ndry[DAY][XDim][YDim];
    int nvap[DAY][XDim][YDim];
    int nakt[DAY][XDim][YDim][Prs1];
    int nmcov[DAY][XDim][YDim][Prs1][Prs2]; 
    int nscov[DAY][XDim][YDim][Prs1][Prs2]; 
    int nrcov[DAY][XDim][YDim][Prs1][Prs2]; 
  };

  struct Product {
    double Fstarttime;
    double Fstoptime;
    float zensol[DAY][XDim][YDim];
    float zensat[DAY][XDim][YDim];
    float psurf[DAY][XDim][YDim];
    float ap_tsurf[DAY][XDim][YDim];
    float ap_esurf[DAY][XDim][YDim];
    float ap_co_mix[DAY][XDim][YDim][Prs]; 
    float ap_co_surf[DAY][XDim][YDim];
    float ap_co_tot[DAY][XDim][YDim];
    float tsurf[DAY][NTHREE][XDim][YDim];
    float esurf[DAY][NTHREE][XDim][YDim];
    float co_mix[DAY][NTHREE][XDim][YDim][Prs]; 
    float co_surf[DAY][NTHREE][XDim][YDim];
    float co_colm[DAY][NTHREE][XDim][YDim];
    float co_colm_diag[DAY][XDim][YDim][NTWO];
    float avgker[DAY][XDim][YDim][Prs1][Prs2];
    float DFS[DAY][XDim][YDim];
    int   isurf[DAY][XDim][YDim];
    int   nco_colm[DAY][XDim][YDim];
    float alt[DAY][NTWO][XDim][YDim]; 
    float chi[DAY][NTWO][XDim][YDim];
    float da_col[DAY][XDim][YDim];
    float wa_col[DAY][XDim][YDim];
    float ak_col[DAY][XDim][YDim][Prs1];
    float me_cov[DAY][XDim][YDim][Prs1][Prs2];
    float sm_cov[DAY][XDim][YDim][Prs1][Prs2];
    float re_cov[DAY][XDim][YDim][Prs1][Prs2];    
  };


  bool Get_rmPixel ( int& );

  void GetMaj_PsurfInd  (MOP02_Num, float [DAY][XDim][YDim], int [DAY][XDim][YDim]);


#endif
