/************************ MOP02_Get_Num.C *************************************************************************\

 PURPOSE
   To get majority psurf isurf at ilat/ilon

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "MOP02.h"
#include <stdlib.h>


void MOP02_Get_Num (MOP02_Geo Geo, MOP02_Num &Num)
{
  int d, i, j, ilat, ilon, dn;

  // initialize psurf and isurf
  for ( d = 0; d < DAY; d++ ) 
    for ( i = 0; i < XDim; i++ )
      for ( j = 0; j < YDim; j++ ) {
	Num.np6[d][i][j]  = 0;
	Num.np7[d][i][j]  = 0;
	Num.np8[d][i][j]  = 0;
	Num.np9[d][i][j]  = 0;
	Num.np10[d][i][j] = 0;
	Num.ni0[d][i][j]  = 0;
	Num.ni1[d][i][j]  = 0;
	Num.ni2[d][i][j]  = 0;
  }
  
  // pixel to grid lat:0-180, lon:0-360
  for (i = 0; i< Geo.timecount; i++ ) {

    if ( Geo.lat[i] > 0 )
      ilat = (int) ( ( (int)Geo.lat[i] + 90 ) / YBIN );
    else
      ilat = (int) ( ( (int)Geo.lat[i] + 89 ) / YBIN );
    if ( Geo.lon[i] > 0 )
      ilon = (int) ( ( (int)Geo.lon[i] + 180 ) / XBIN );
    else
      ilon = (int) ( ( (int)Geo.lon[i] + 179 ) / XBIN );
    if ( ilon == 360 ) ilon = 359;
    if ( ilat == 180 ) ilat = 179;

    // set up day / night flag
    if ( Geo.solzen[i] < NIGHT ) 
      dn = 0;
    else 
      dn = 1;

    // get the pixel number for each valid levels with surface pressure
    if( Geo.presurf[i]>900.0) 
      Num.np10[dn][ilon][ilat] += 1;
    else if( Geo.presurf[i]> 800.0) 
      Num.np9[dn][ilon][ilat] += 1;
    else if( Geo.presurf[i]> 700.0) 
      Num.np8[dn][ilon][ilat] += 1;
    else if( Geo.presurf[i]> 600.0) 
      Num.np7[dn][ilon][ilat] += 1;
    else if( Geo.presurf[i]> 500.0) 
      Num.np6[dn][ilon][ilat] += 1;
    
    // get the pixel number for each kind of surface index:  0, 1, 2 for day / night
    if ( Geo.indsurf[i] == 0 )
      Num.ni0[dn][ilon][ilat] += 1;
    else if (Geo.indsurf[i] == 1 ) 
      Num.ni1[dn][ilon][ilat] += 1;
    else if (Geo.indsurf[i] == 2) 
      Num.ni2[dn][ilon][ilat] += 1;
  }
}
