/********** RangeDateTime.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03  Debbie Mao

 $Log$

\**********************************************************************************************************************/
#include <PGS_TD.h>
#include "RangeDateTime.h"
#include "DiagnosticReporter.h"
#include <string.h>

extern diagnostic_reporter diagnosticreporter;

range_date_time :: range_date_time ()
                 : attribute_group ()
{
  rangeendingdate    [0] = '\0';
  rangeendingtime    [0] = '\0';
  rangebeginningdate [0] = '\0';
  rangebeginningtime [0] = '\0';
}


range_date_time :: ~range_date_time ()
{
  ;
}


bool range_date_time :: Set (PGSt_MET_handle handle, double const& starttime, double const& stoptime)
{
  bool isset = false;
  char UTC_starttime[28], UTC_stoptime[28];
  PGSt_SMF_status smfstatus;

  // get UTC time for starttime and stoptime
  smfstatus = PGS_TD_TAItoUTC(starttime,UTC_starttime);
  if (smfstatus != PGS_S_SUCCESS) 
    diagnosticreporter.Write(DIAGNOSTICS_ERROR, 860, "Could not convert starttime TAI time ");
  smfstatus = PGS_TD_TAItoUTC(stoptime,UTC_stoptime);
  if (smfstatus != PGS_S_SUCCESS) 
    diagnosticreporter.Write(DIAGNOSTICS_ERROR, 862, "Could not convert stoptime TAI time ");

  // retrieve the ending date & time info
  (void) strncpy (rangeendingdate, UTC_stoptime, (DATE_SIZE - 1));
  rangeendingdate [DATE_SIZE - 1] = '\0';
  (void) strncpy (rangeendingtime, ( UTC_stoptime + 11), (TIME_SIZE - 1));
  rangeendingtime [TIME_SIZE - 1] = '\0';

  // retrieve the beginning date & time info
  (void) strncpy (rangebeginningdate, UTC_starttime, (DATE_SIZE - 1));
  rangebeginningdate[DATE_SIZE - 1] = '\0';
  (void) strncpy (rangebeginningtime, ( UTC_starttime + 11), (TIME_SIZE - 1));
  rangebeginningtime [TIME_SIZE - 1] = '\0';
  
  // control rangeendingdate = rangebeginningdate
  if ( int issamedate = strcmp ( rangebeginningdate, rangeendingdate ) != 0 ) {
    (void) strcpy ( rangeendingdate, rangebeginningdate );
    (void) strcpy ( rangeendingtime, "23:59:59.999" );
  }

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr;
  sptr = rangeendingdate;
  if (attribute_group::Set (handle, "RangeEndingDate", (void*) &sptr)) {
    sptr = rangeendingtime;
    if (attribute_group::Set (handle, "RangeEndingTime", (void*) &sptr)) {
      sptr = rangebeginningdate;
      if (attribute_group::Set (handle, "RangeBeginningDate", (void*) &sptr)) {
        sptr = rangebeginningtime;
        if (attribute_group::Set (handle, "RangeBeginningTime", (void*) &sptr))
          isset = true;
      }
    }
  }

  return isset;
}
