/********** ECSDataGranule.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03  Debbie Mao

 $Log$

\**********************************************************************************************************************/
#include <string.h>
#include "ECSDataGranule.h"
#include "DiagnosticReporter.h"
#include "Driver.h"

extern diagnostic_reporter diagnosticreporter;

ecs_data_granule :: ecs_data_granule ()
                  : attribute_group ()
{
  ;
}


ecs_data_granule :: ~ecs_data_granule ()
{
  ;
}


void ecs_data_granule :: ExtractFileName (char fullname [], char extracted []) const
{
  // save the full name (so it wont get mangled)
  char newfullname [PGSd_PC_FILE_PATH_MAX];
  (void) strcpy (newfullname, fullname);

  // recover the filename by parsing the full name with '/' as a token delimiter
  char* token = strtok (newfullname, "/");
  (void) strcpy (extracted, token);
  while ((token = strtok (NULL, "/")) != NULL) {
    (void) strcpy (extracted, token);
  }
}


bool ecs_data_granule :: Set (PGSt_MET_handle handle)
{
  bool isset = false;

  // get the full filename from the filelogical
  PGSt_integer version = 1;
  char fullname  [PGSd_PC_FILE_PATH_MAX];
  char extracted [PGSd_PC_FILE_PATH_MAX];
  if (PGS_PC_GetReference (M3LOGICAL, &version, fullname) != PGS_S_SUCCESS)
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 820, "Could not get filename");

  // sptr is necessary for some bizarre toolkit reason.
  char* sptr = extracted;

  // extract the filename from the full name and store the filename
  ExtractFileName (fullname, extracted);
  if (attribute_group::Set (handle, "LocalGranuleID", (void*) &sptr)) 
    isset = true;

  return isset;
}
