/********** AttributeGroup.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao

 $Log$

\**********************************************************************************************************************/
#include "AttributeGroup.h"
#include "Driver.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

attribute_group :: attribute_group ()
{
  ;
}


attribute_group :: ~attribute_group ()
{
  ;
}


bool attribute_group :: Set (PGSt_MET_handle handle, string const& attrname, void const* const attrval)
{
  bool isset = true;

  // set the attribute
  if (PGS_MET_SetAttr (handle, (char*) attrname.c_str (), (void*) attrval) != PGS_S_SUCCESS) {
    isset = false;
    string message = "Could not set metadata attribute ";
    message += attrname;
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 810, message);
  }

  return isset;
}
