/************************ Var_Grid.C *******************************************************************************\

 PURPOSE
   To get variability for 1x1 degree grid

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;


void  Var_Grid ( MOP03_Num Num3, Product &Prod)
{

  int d, r, k, ilat, ilon;

  // Step #3: 2/2 final action for L3 variability
  for ( d = 0; d < DAY; d++ )
    for ( ilon = 0; ilon < XDim; ilon++) 
      for ( ilat = 0; ilat < YDim; ilat++ ) {

	// surface tempressure
	if ( Num3.ntsurf[d][0][ilon][ilat] > NLIMIT )
	  Prod.tsurf[d][2][ilon][ilat] = sqrtf(Prod.tsurf[d][2][ilon][ilat] / Num3.ntsurf[d][0][ilon][ilat]);
	else 
	  Prod.tsurf[d][2][ilon][ilat] = MISSING_VALUE;

	// surface emissivity
	if ( Num3.nesurf[d][0][ilon][ilat] > NLIMIT )
	  Prod.esurf[d][2][ilon][ilat] = sqrtf(Prod.esurf[d][2][ilon][ilat] / Num3.nesurf[d][0][ilon][ilat]);
	else 
	  Prod.esurf[d][2][ilon][ilat] = MISSING_VALUE;

	// co total colomn
	if ( Prod.nco_colm[d][ilon][ilat] > NLIMIT )
	  Prod.co_colm[d][2][ilon][ilat] = sqrtf(Prod.co_colm[d][2][ilon][ilat] / Prod.nco_colm[d][ilon][ilat]) * exp(18.0);
	else 
	  Prod.co_colm[d][2][ilon][ilat] = MISSING_VALUE;

	// CO surface mixing ratio
	if ( Num3.nco_surf [d][ilon][ilat] > NLIMIT && Prod.co_surf[d][0][ilon][ilat] > COLIMIT ) {
	  Prod.co_surf[d][2][ilon][ilat] = sqrtf(Prod.co_surf[d][2][ilon][ilat] / Num3.nco_surf[d][ilon][ilat]);
	  Prod.co_surf[d][0][ilon][ilat] = powf(10,Prod.co_surf[d][0][ilon][ilat]);
	  Prod.co_surf[d][1][ilon][ilat] = Prod.co_surf[d][0][ilon][ilat] * Prod.co_surf[d][1][ilon][ilat];
	  Prod.co_surf[d][2][ilon][ilat] = Prod.co_surf[d][0][ilon][ilat] * Prod.co_surf[d][2][ilon][ilat] / LOG10E;
	}
	else 
	  for ( r = 0; r < NTHREE; r++ ) 	    
	    Prod.co_surf[d][r][ilon][ilat] = MISSING_VALUE;

	// co mixing ratio
	for ( k = 0; k < Prs; k++) {
	  if ( Num3.nco_mix[d][ilon][ilat][k] > NLIMIT && Prod.co_mix[d][0][ilon][ilat][k] > COLIMIT ) {
	    Prod.co_mix[d][2][ilon][ilat][k]=sqrtf(Prod.co_mix[d][2][ilon][ilat][k] / Num3.nco_mix[d][ilon][ilat][k]);
	    Prod.co_mix[d][0][ilon][ilat][k]=powf(10,Prod.co_mix[d][0][ilon][ilat][k]);
	    Prod.co_mix[d][1][ilon][ilat][k]=Prod.co_mix[d][0][ilon][ilat][k] * Prod.co_mix[d][1][ilon][ilat][k];
	    Prod.co_mix[d][2][ilon][ilat][k]=Prod.co_mix[d][0][ilon][ilat][k] * Prod.co_mix[d][2][ilon][ilat][k]/LOG10E;
	    }
	  else
	    for ( r = 0; r < NTHREE; r++ ) 	    
	      Prod.co_mix[d][r][ilon][ilat][k] = MISSING_VALUE;	
	}

	// DEM Altitude
	if ( Num3.nalt[d][ilon][ilat] > NLIMIT )
	  Prod.alt[d][1][ilon][ilat] = sqrtf(Prod.alt[d][1][ilon][ilat] / Num3.nalt[d][ilon][ilat]);
	else 
	  Prod.alt[d][1][ilon][ilat] = MISSING_VALUE;

	// Chi2
	if ( Num3.nchi[d][ilon][ilat] > NLIMIT )
	  Prod.chi[d][1][ilon][ilat] = sqrtf(Prod.chi[d][1][ilon][ilat] / Num3.nchi[d][ilon][ilat]);
	else 
	  Prod.chi[d][1][ilon][ilat] = MISSING_VALUE;
      } 
}
