/************************ Stddev_Grid.C *******************************************************************************\

 PURPOSE
   To calculate std dev for 1x1 degree grid

 REVISION HISTORY
   02/09   Debbie Mao -- match V4 new L2 data fields
   07/13   Debbie Mao -- V6

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;

void Stddev_Grid ( int rmPix, MOP02_Geo Geo, MOP02_Dat1 Dat1, MOP02_Dat2 Dat2, float psurfmaj[DAY][XDim][YDim], 
		   Product &Prod )
{
  int i, k, ilat, ilon, dn, rmflag;
  float snr5, snr6;

  // add up for calculating L3 stddev --- Step #2: 1/2 action for getting data variability
  for (i = 0; i< Geo.timecount; i++ ) {

    // set up day / night flag
    if ( Geo.solzen[i] < NIGHT ) 
      dn = 0;
    else 
      dn = 1;

    // grid index lat:0-180, lon:0-360 -> SW corner
    if ( Geo.lat[i] > 0 ) 
      ilat = (int) ( ( (int)Geo.lat[i] + 90 ) / YBIN );
    else 
      ilat = (int) ( ( (int)Geo.lat[i] + 89 ) / YBIN );
    if ( Geo.lon[i] > 0 ) 
      ilon = (int) ( ( (int)Geo.lon[i] + 180 ) / XBIN );
    else 
      ilon = (int) ( ( (int)Geo.lon[i] + 179 ) / XBIN );
    if ( ilon == 360 ) ilon = 359;
    if ( ilat == 180 ) ilat = 179;

    // set up rmPix flag 0-keep, 1-TIR, 2-NIR, 3-JNT
    rmflag = 0;

    //make sure tha data are at the same level with the majority presure level
    if( (psurfmaj[dn][ilon][ilat] == PSURF500 && (Geo.presurf[i]>500. && Geo.presurf[i]<=600.)) ||
        (psurfmaj[dn][ilon][ilat] == PSURF600 && (Geo.presurf[i]>600. && Geo.presurf[i]<=700.)) ||
        (psurfmaj[dn][ilon][ilat] == PSURF700 && (Geo.presurf[i]>700. && Geo.presurf[i]<=800.)) ||
        (psurfmaj[dn][ilon][ilat] == PSURF800 && (Geo.presurf[i]>800. && Geo.presurf[i]<=900.)) ||
        (psurfmaj[dn][ilon][ilat] == PSURF900 && Geo.presurf[i]>900.) ) {

      //make sure only the dominated surface indicator pixels going into the grid
      if ((Geo.indsurf[i] == Prod.isurf[dn][ilon][ilat] || Prod.isurf[dn][ilon][ilat] == 2) && 
	  (Geo.indsurf[i] != MISSING_INT)) {

	//make sure the pixel is not noisy 
	snr5 = 0.0;
	snr6 = 0.0;
	if ( (Dat1.L1rad[i][3][0]!= MISSING_VALUE) && (Dat1.L1rad[i][3][1]!= MISSING_VALUE) ) {
	  snr5 = Dat1.L1rad[i][3][0] / Dat1.L1rad[i][3][1];
	}
	if ( (Dat1.L1rad[i][9][0]!= MISSING_VALUE) && (Dat1.L1rad[i][9][1]!= MISSING_VALUE) ) {
	  snr6 = Dat1.L1rad[i][9][0] / Dat1.L1rad[i][9][1];
	}

	switch (rmPix) {
	case 1: if ( Dat1.swInd[i][0] == 3 || snr5 < 1000 ) // TIR
	    rmflag = 1;	  
	  break;
	case 2:  if ( snr6 < 400 )  // NIR
	    rmflag = 1;
	  break;
	case 3: if (Dat1.swInd[i][0] == 3)    // JNT
	    rmflag = 1;
	  switch (dn) {
	  case 0: if (snr5 < 1000 && snr6 < 400)  // day time
	      rmflag = 1;
	    break;
	  case 1: if (snr5 < 1000 )  // nit time
	      rmflag = 1;
	    break;
	  }	      
	  break;
	}

	if (rmflag == 0) {

	  // surface tempressure
	  if ( Dat2.tsurf [i][0] != MISSING_VALUE && Prod.tsurf[dn][0][ilon][ilat] != MISSING_VALUE ) 
	    Prod.tsurf[dn][2][ilon][ilat] += powf((Dat2.tsurf[i][0]-Prod.tsurf[dn][0][ilon][ilat]), 2);	  

	  // surface emissivity
	  if ( Dat2.esurf [i][0] != MISSING_VALUE && Prod.esurf[dn][0][ilon][ilat] != MISSING_VALUE ) 
	    Prod.esurf[dn][2][ilon][ilat] += powf((Dat2.esurf[i][0]-Prod.esurf[dn][0][ilon][ilat]), 2);	

	  // co mixing ratio     
	  for ( k = 0; k < Prs; k++) {
	    if ( Dat2.comix[i][k][0] > COLIMIT && Prod.co_mix[dn][0][ilon][ilat][k] > COLIMIT ) 
	      Prod.co_mix[dn][2][ilon][ilat][k] += powf((log10f(Dat2.comix[i][k][0])-Prod.co_mix[dn][0][ilon][ilat][k]),2);
	  }

	  // CO surface mixing ratio
	  if ( Dat2.cosurf [i][0] > COLIMIT && Prod.co_surf[dn][0][ilon][ilat] > COLIMIT ) 
	    Prod.co_surf[dn][2][ilon][ilat] += powf((log10f(Dat2.cosurf[i][0])-Prod.co_surf[dn][0][ilon][ilat]), 2);

	  // co total colomn
	  if ( Dat2.cotot[i][0] != MISSING_VALUE && Prod.co_colm [dn][0][ilon][ilat] != MISSING_VALUE)  {
	    //Prod.co_colm [dn][2][ilon][ilat] += powf((Dat2.cotot[i][0]-Prod.co_colm [dn][0][ilon][ilat]), 2);
	    Prod.co_colm [dn][2][ilon][ilat] += powf( ( (Dat2.cotot[i][0]-Prod.co_colm [dn][0][ilon][ilat]) / exp(18.0) ), 2 );
	  }

	  // DEM Altitude
	  if ( Dat2.demalt [i] != MISSING_VALUE && Prod.alt[dn][0][ilon][ilat] != MISSING_VALUE ) 
	    Prod.alt[dn][1][ilon][ilat] += powf((Dat2.demalt[i]-Prod.alt[dn][0][ilon][ilat]), 2);	  
      
	  // Chi2
	  if ( Dat2.chi2 [i] != MISSING_VALUE && Prod.chi[dn][0][ilon][ilat] != MISSING_VALUE ) 
	    Prod.chi[dn][1][ilon][ilat] += powf((Dat2.chi2[i]-Prod.chi[dn][0][ilon][ilat]), 2);
	}
      }
    }
  }
}
