/************************ Avg_Grid.C *******************************************************************************\

 PURPOSE
   To average pixel data into 1x1 degree grid

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;


void Avg_Grid ( MOP03_Num Num3, Product &Prod)

{
  int  d, t, j, k, ilat, ilon;
  bool badAker;

  // Take averages --- Step #1: fields with data only done here -> mean & mean uncertainty ---
  for ( d = 0; d < DAY; d++ )
    for ( ilon = 0; ilon < XDim; ilon++)
      for ( ilat = 0; ilat < YDim; ilat++ ) {
	badAker = false;

	if ( Num3.nzensol [d][ilon][ilat] > NLIMIT )   
	  Prod.zensol[d][ilon][ilat] = Prod.zensol[d][ilon][ilat] / Num3.nzensol[d][ilon][ilat];
	else 
	  Prod.zensol[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nzensat [d][ilon][ilat] > NLIMIT )   
	  Prod.zensat[d][ilon][ilat] = Prod.zensat[d][ilon][ilat] / Num3.nzensat[d][ilon][ilat];
	else 
	  Prod.zensat[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.npsurf [d][ilon][ilat] > NLIMIT )   
	  Prod.psurf[d][ilon][ilat] = Prod.psurf[d][ilon][ilat] / Num3.npsurf[d][ilon][ilat];
	else 
	  Prod.psurf[d][ilon][ilat] = MISSING_VALUE;

	for ( j = 0; j < Prs1; j++)
	  for ( k = 0; k < Prs2; k++) {	
	    if ( Num3.navgker[d][ilon][ilat][j][k] > NLIMIT ) 
	      Prod.avgker[d][ilon][ilat][j][k] = Prod.avgker[d][ilon][ilat][j][k] / Num3.navgker[d][ilon][ilat][j][k];
	    else
	      Prod.avgker[d][ilon][ilat][j][k] = MISSING_VALUE;
	                             
	    if ( (Prod.avgker[d][ilon][ilat][j][k] < AVGKER_MIN || Prod.avgker[d][ilon][ilat][j][k] > AVGKER_MAX ) &&
		 (Prod.avgker[d][ilon][ilat][j][k] != MISSING_VALUE) ) {
	      badAker = true;
	      goto JKOUT;
	    }
	  }
        JKOUT: if ( badAker ) {
	  for ( j = 0; j < Prs1; j++)
	    for ( k = 0; k < Prs2; k++) 
	      Prod.avgker[d][ilon][ilat][j][k] = MISSING_VALUE;
	}

	if ( Num3.nap_tsurf[d][ilon][ilat] > NLIMIT )   
	  Prod.ap_tsurf[d][ilon][ilat] = Prod.ap_tsurf[d][ilon][ilat] / Num3.nap_tsurf[d][ilon][ilat];
	else 
	  Prod.ap_tsurf[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nap_esurf[d][ilon][ilat] > NLIMIT )   
	  Prod.ap_esurf[d][ilon][ilat] = Prod.ap_esurf[d][ilon][ilat] / Num3.nap_esurf[d][ilon][ilat];
	else 
	  Prod.ap_esurf[d][ilon][ilat] = MISSING_VALUE;

	for ( k = 0; k < Prs; k++) {
	  if ( Num3.nap_co_mix[d][ilon][ilat][k] > NLIMIT ) {
	    Prod.ap_co_mix[d][ilon][ilat][k] = Prod.ap_co_mix[d][ilon][ilat][k] / Num3.nap_co_mix[d][ilon][ilat][k];
	    Prod.ap_co_mix[d][ilon][ilat][k] = powf(10, Prod.ap_co_mix[d][ilon][ilat][k]);
	  }
	  else 
	    Prod.ap_co_mix[d][ilon][ilat][k] = MISSING_VALUE;
        }

	if ( Num3.nap_co_surf[d][ilon][ilat] > NLIMIT ) {
	  Prod.ap_co_surf[d][ilon][ilat] = Prod.ap_co_surf[d][ilon][ilat] / Num3.nap_co_surf[d][ilon][ilat];
	  Prod.ap_co_surf[d][ilon][ilat] = powf(10, Prod.ap_co_surf[d][ilon][ilat]);
	}
	else 
	  Prod.ap_co_surf[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nap_co_tot[d][ilon][ilat] > NLIMIT ) 
	  Prod.ap_co_tot[d][ilon][ilat] = Prod.ap_co_tot[d][ilon][ilat] / Num3.nap_co_tot[d][ilon][ilat];
	else 
	  Prod.ap_co_tot[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nDFS [d][ilon][ilat] > NLIMIT )   
	  Prod.DFS[d][ilon][ilat] = Prod.DFS[d][ilon][ilat] / Num3.nDFS[d][ilon][ilat];
	else 
	  Prod.DFS[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nalt [d][ilon][ilat] > NLIMIT )   
	  Prod.alt[d][0][ilon][ilat] = Prod.alt[d][0][ilon][ilat] / Num3.nalt[d][ilon][ilat];
	else 
	  Prod.alt[d][0][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nchi [d][ilon][ilat] > NLIMIT )   
	  Prod.chi[d][0][ilon][ilat] = Prod.chi[d][0][ilon][ilat] / Num3.nchi[d][ilon][ilat];
	else 
	  Prod.chi[d][0][ilon][ilat] = MISSING_VALUE;

	if ( Num3.ndry [d][ilon][ilat] > NLIMIT )   
	  Prod.da_col[d][ilon][ilat] = Prod.da_col[d][ilon][ilat] / Num3.ndry[d][ilon][ilat];
	else 
	  Prod.da_col[d][ilon][ilat] = MISSING_VALUE;

	if ( Num3.nvap [d][ilon][ilat] > NLIMIT )   
	  Prod.wa_col[d][ilon][ilat] = Prod.wa_col[d][ilon][ilat] / Num3.nvap[d][ilon][ilat];
	else 
	  Prod.wa_col[d][ilon][ilat] = MISSING_VALUE;

	for ( j = 0; j < Prs1; j++) {
	  if ( Num3.nakt [d][ilon][ilat][j] > NLIMIT )   
	    Prod.ak_col[d][ilon][ilat][j] = Prod.ak_col[d][ilon][ilat][j] / Num3.nakt[d][ilon][ilat][j];
	  else 
	    Prod.ak_col[d][ilon][ilat][j] = MISSING_VALUE;

	  for ( k = 0; k < Prs2; k++) {	
	    if ( Num3.nmcov[d][ilon][ilat][j][k] > NLIMIT ) 
	      Prod.me_cov[d][ilon][ilat][j][k] = Prod.me_cov[d][ilon][ilat][j][k] / Num3.nmcov[d][ilon][ilat][j][k];
	    else
	      Prod.me_cov[d][ilon][ilat][j][k] = MISSING_VALUE;

	    if ( Num3.nscov[d][ilon][ilat][j][k] > NLIMIT ) 
	      Prod.sm_cov[d][ilon][ilat][j][k] = Prod.sm_cov[d][ilon][ilat][j][k] / Num3.nscov[d][ilon][ilat][j][k];
	    else
	      Prod.sm_cov[d][ilon][ilat][j][k] = MISSING_VALUE;

	    if ( Num3.nrcov[d][ilon][ilat][j][k] > NLIMIT ) 
	      Prod.re_cov[d][ilon][ilat][j][k] = Prod.re_cov[d][ilon][ilat][j][k] / Num3.nrcov[d][ilon][ilat][j][k];
	    else
	      Prod.re_cov[d][ilon][ilat][j][k] = MISSING_VALUE;
	  }
	}

	// 0 -- data,  1 -- mean uncertainty
	for ( t = 0; t < NTWO; t++) {
	  // surface tempressure
	  if ( Num3.ntsurf[d][t][ilon][ilat] > NLIMIT )   
	    Prod.tsurf[d][t][ilon][ilat] = Prod.tsurf[d][t][ilon][ilat] / Num3.ntsurf[d][t][ilon][ilat];
	  else 
	    Prod.tsurf[d][t][ilon][ilat] = MISSING_VALUE;

	  // surface emissivity
	  if ( Num3.nesurf[d][t][ilon][ilat] > NLIMIT )   
	    Prod.esurf[d][t][ilon][ilat] = Prod.esurf[d][t][ilon][ilat] / Num3.nesurf[d][t][ilon][ilat];
	  else 
	    Prod.esurf[d][t][ilon][ilat] = MISSING_VALUE;

	  // co mixing ratio
	  for ( k = 0; k < Prs; k++) {
	    if ( Num3.nco_mix[d][ilon][ilat][k] > NLIMIT )
	      Prod.co_mix[d][t][ilon][ilat][k] = Prod.co_mix[d][t][ilon][ilat][k] / Num3.nco_mix[d][ilon][ilat][k];
	    else
	      Prod.co_mix[d][t][ilon][ilat][k] = MISSING_VALUE;
	  }

	  // CO surface mixing ratio
	  if ( Num3.nco_surf [d][ilon][ilat] > NLIMIT )   
	    Prod.co_surf[d][t][ilon][ilat] = Prod.co_surf[d][t][ilon][ilat] / Num3.nco_surf[d][ilon][ilat] ;
	  else 
	    Prod.co_surf[d][t][ilon][ilat] = MISSING_VALUE;

	  // co total colomn
	  if ( Num3.nco_totmp[d][t][ilon][ilat] > NLIMIT ) 
	    Prod.co_colm[d][t][ilon][ilat] = Prod.co_colm[d][t][ilon][ilat] / Num3.nco_totmp[d][t][ilon][ilat];
	  else {
	    Prod.co_colm[d][t][ilon][ilat] = MISSING_VALUE;
	    Prod.isurf[d][ilon][ilat] = MISSING_INT;
	  }

	  // co total colomn diag: 0-smoothing err, 1-measurement err
	  if ( Num3.nco_diag[d][ilon][ilat][t] > NLIMIT ) 
	    Prod.co_colm_diag[d][ilon][ilat][t] = Prod.co_colm_diag[d][ilon][ilat][t] / Num3.nco_diag[d][ilon][ilat][t];
	  else 
	    Prod.co_colm_diag[d][ilon][ilat][t] = MISSING_VALUE;

	}

	if ( Num3.nco_totmp[d][0][ilon][ilat] > NLIMIT )
	  Prod.nco_colm[d][ilon][ilat] = Num3.nco_totmp[d][0][ilon][ilat];
	else
	  Prod.nco_colm[d][ilon][ilat] = MISSING_INT;
      } 

  diagnosticreporter.Write(DIAGNOSTICS_WARNING, 400, "The pixel data is averaged into the grid." );

}
