/********** MOPITTTime.h **********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/97   Charles Cavanaugh
   09/99   Charles Cavanaugh
   12/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOPITT_TIME_

  #define _MOPITT_L1_MOPITT_TIME_

  #include <string>
  #include "PGS_TYPES.h"

  using namespace std;

  class mopitt_time {
    private :
      static int const NCAR_UTC_ERROR;
      static int const NCAR_UTC_WARNING;
      static int const TAI_UTC_ERROR;
      static int const TAI_UTC_WARNING;
      static int const UTC_NCAR_ERROR;
      static int const UTC_TAI_ERROR;
      static int const UTC_TAI_WARNING;

      int         day;
      int         msecs;
      PGSt_double tai;
      string      utc;

      bool MakeNCARFromUTC ();
      bool MakeTAIFromUTC  ();
      bool MakeUTCFromNCAR ();
      bool MakeUTCFromTAI  ();

    protected :

    public :
      mopitt_time  ();
      mopitt_time  (int, int);
      mopitt_time  (double);
      mopitt_time  (string const&);
      ~mopitt_time ();

      mopitt_time& operator =  (mopitt_time const&);
      bool         operator == (mopitt_time const&) const;
      bool         operator != (mopitt_time const&) const;
      bool         operator <  (mopitt_time const&) const;
      bool         operator <= (mopitt_time const&) const;
      bool         operator >  (mopitt_time const&) const;
      bool         operator >= (mopitt_time const&) const;

      bool          Set        (int, int);
      bool          Set        (double);
      bool          Set        (string const&);
      int           GetDay     () const {return day;}
      int           GetMsecs   () const {return msecs;}
      double        GetTAI     () const {return (double) tai;}
      string const& GetUTC     () const {return utc;}
  };

#endif
