/********** TableTrainList.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "TableTrainList.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

table_train_list :: table_train_list ()
                  : trains ()
{
  next = 0;
}


table_train_list :: ~table_train_list ()
{
  table_train* tabletrain;

  // make sure the list is empty
  while (! trains.empty ()) {
    tabletrain = trains.front ();
    delete tabletrain;
    trains.pop_front ();
  }
}


void table_train_list :: AddTrain (table_train* tabletrain)
{
  trains.push_back (tabletrain);
}


bool table_train_list :: GetNext (table_train** tabletrain)
{
  bool isfound = false;

  deque <table_train*> :: const_iterator iter = trains.begin () + next;
  if (iter != trains.end ()) {
    *tabletrain = (table_train*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}


table_train* table_train_list :: GetTrain (mopitt_time const& searchtime, int& startindex) const
{
  table_train* tabletrain = NULL;

  // if there are entries in the list
  if (! trains.empty ()) {

    // set the iterator
    deque <table_train*> :: const_iterator iter = trains.begin () + startindex;

    // get the time for the iterator
    mopitt_time traintime (((*iter)->GetTime ()).GetTAI ());

    // search only if the searchtime is >= iter time
    if (searchtime >= traintime) {

      // setup the search
      iter++;
      bool keeplooking = true;

      // search while there is data and variant still set
      while (iter != trains.end () && keeplooking) {
  
        // get the time for this iteration and compare it with the search time; if less, then stop looking
        traintime.Set (((*iter)->GetTime ()).GetTAI ());
        if (searchtime < traintime)
          keeplooking = false;
        else {

          // set up for the next comparison
          iter++;
          startindex++;
        }
      }
    }

    // startindex points to the train we want
    iter = trains.begin () + startindex;
    tabletrain = (*iter);
  }

  return tabletrain;
}
