/********** TableTrainData.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_TABLE_TRAIN_DATA_

  #define _MOPITT_L1_TABLE_TRAIN_DATA_

  class table_train_data {
    private :
      static int const ACTIVE_TABLE_CONFIG_PRIMARY_OFFSET;
      static int const ACTIVE_TABLE_SPM_1_PRIMARY_OFFSET;
      static int const ACTIVE_TABLE_SPM_2_PRIMARY_OFFSET;
      static int const CONFIG_TABLE_DATA_START;
      static int const CONFIG_TABLE_DATA_LENGTH;
      static int const CONFIG_TABLE_FIRST_PRIMARY_NUMBER;
      static int const SPM_1_TABLE_DATA_START;
      static int const SPM_1_TABLE_FIRST_PRIMARY_NUMBER;
      static int const SPM_2_TABLE_DATA_START;
      static int const SPM_2_TABLE_FIRST_PRIMARY_NUMBER;
      static int const SPM_TABLE_DATA_LENGTH;
      static int const TABLE_NUMBER_OFFSET;

    protected :
      static int const TIME_FIELDS;
      static int const SCALEFACTOR_LMC_24BIT_OFFSET;

      int dataindex;

      int   GetConfigTableOffset (unsigned char* packetdata) const
                                  {return CONFIG_TABLE_DATA_START + ((packetdata [ACTIVE_TABLE_CONFIG_PRIMARY_OFFSET] -
                                          CONFIG_TABLE_FIRST_PRIMARY_NUMBER) * CONFIG_TABLE_DATA_LENGTH);}
      int   GetSPM1TableOffset   (unsigned char* packetdata) const
                                  {return SPM_1_TABLE_DATA_START + ((packetdata [ACTIVE_TABLE_SPM_1_PRIMARY_OFFSET] -
                                          SPM_1_TABLE_FIRST_PRIMARY_NUMBER) * SPM_TABLE_DATA_LENGTH);}
      int   GetSPM2TableOffset   (unsigned char* packetdata) const
                                  {return SPM_2_TABLE_DATA_START + ((packetdata [ACTIVE_TABLE_SPM_2_PRIMARY_OFFSET] -
                                          SPM_2_TABLE_FIRST_PRIMARY_NUMBER) * SPM_TABLE_DATA_LENGTH);}
      short GetSPMValue          (unsigned char spmdata) const {return (short) (255 - spmdata);}
  
    public :
      table_train_data ();
      virtual ~table_train_data () = 0;
  };

#endif
