/********** TableTrain2Data.h *****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_TABLE_TRAIN2_DATA_

  #define _MOPITT_L1_TABLE_TRAIN2_DATA_

  #include "TableTrainData.h"
  #include "TableTrainList.h"
  #include "HDFVGroup.h"
  #include "HDFVData.h"

  class table_train2_data : public table_train_data {
    private :
      static int const FIELDCOUNT;
      static int const DATA_FIELDS;
      static int const CHOPPER_OPEN_SAMPLES_OFFSET;
      static int const CHOPPER_CLOSED_SAMPLES_OFFSET;
      static int const LMC_SECTOR_CHOPPER_CYCLES_OFFSET;
      static int const PMC_STROKE_CHOPPER_CYCLES_OFFSET;
      static int const SCALEFACTOR_PMC_24BIT_OFFSET;

      table_train_list trainlist;
      hdf_vgroup       vgroup;
      hdf_vdata        vdata;

    protected :
  
    public :
      table_train2_data ();
      ~table_train2_data ();

      void AddPacket (mopitt_time const&, unsigned char*);
      bool Close     ();
      bool Define    (int32, int32);
      void GetData   (mopitt_time const&, short&, short&, short&, short&, short&, short&);
      bool Write     ();
  };

#endif
