/********** TableTrain2Data.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "TableTrain2Data.h"
#include "LMCPMCTableTrain.h"

int const table_train2_data::FIELDCOUNT                       = 8;
int const table_train2_data::DATA_FIELDS                      = (FIELDCOUNT - TIME_FIELDS);
int const table_train2_data::CHOPPER_OPEN_SAMPLES_OFFSET      = 10;
int const table_train2_data::CHOPPER_CLOSED_SAMPLES_OFFSET    = 12;
int const table_train2_data::LMC_SECTOR_CHOPPER_CYCLES_OFFSET = 16;
int const table_train2_data::PMC_STROKE_CHOPPER_CYCLES_OFFSET = 19;
int const table_train2_data::SCALEFACTOR_PMC_24BIT_OFFSET     = 18;

table_train2_data :: table_train2_data ()
                   : table_train_data ()
                   , trainlist ()
                   , vgroup ()
                   , vdata ()
{
  ;
}


table_train2_data :: ~table_train2_data ()
{
  ;
}


void table_train2_data :: AddPacket (mopitt_time const& packettime, unsigned char* packetdata)
{
  // get the table offsets
  int configoffset = GetConfigTableOffset (packetdata);
  int spmoffset = GetSPM1TableOffset (packetdata);

  // make a new train object with the data
  table_train* tabletrain = new lmcpmc_table_train (packettime,
                                               ((packetdata[configoffset + SCALEFACTOR_LMC_24BIT_OFFSET] * 256) +
                                                (short) packetdata[configoffset + SCALEFACTOR_LMC_24BIT_OFFSET + 1]),
                                               ((packetdata[configoffset + SCALEFACTOR_PMC_24BIT_OFFSET] * 256) +
                                                (short) packetdata[configoffset + SCALEFACTOR_PMC_24BIT_OFFSET + 1]),
                                               GetSPMValue (packetdata[spmoffset + CHOPPER_OPEN_SAMPLES_OFFSET]),
                                               GetSPMValue (packetdata[spmoffset + CHOPPER_CLOSED_SAMPLES_OFFSET]),
                                               GetSPMValue (packetdata[spmoffset + LMC_SECTOR_CHOPPER_CYCLES_OFFSET]),
                                               GetSPMValue (packetdata[spmoffset + PMC_STROKE_CHOPPER_CYCLES_OFFSET]));

  // add the train object to the list
  trainlist.AddTrain (tabletrain);
}


bool table_train2_data :: Close ()
{
  bool isclosed = false;

  if (vdata.Close ())
    if (vgroup.Close ())
      isclosed = true;

  return isclosed;
}


bool table_train2_data :: Define (int32 fileid, int32 tableid)
{
  bool isdefined = false;

  if (vgroup.Create ("Table Train 2 Group", "Table Data Group", fileid))
    if (vdata.Create ("Table Train 2 Data", "Table Train Data", fileid)) {
      string const fieldnames [FIELDCOUNT] = {"Days", "Milliseconds", "Chopper Open Samples", "Chopper Closed Samples",
                                              "LMC Scale Factor", "PMC Scale Factor", "LMC Chopper Cycles", 
                                              "PMC Chopper Cycles"};
      int32 datatypes [FIELDCOUNT] = {DFNT_INT32, DFNT_INT32, DFNT_INT16, DFNT_INT16, DFNT_INT16, DFNT_INT16, 
                                      DFNT_INT16, DFNT_INT16};
      int32 orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, 1, 1};
      if (vdata.Define (FIELDCOUNT, datatypes, orders, fieldnames))
        if (vdata.Set (FIELDCOUNT, fieldnames))
          if (vdata.Insert (vgroup.GetID ()))
            if (vgroup.Insert (tableid))
              isdefined = true;
    }

  return isdefined;
}


void table_train2_data :: GetData (mopitt_time const& searchtime, short& chopperopensamples,
                                   short& chopperclosedsamples, short& lmcscalefactor, short& pmcscalefactor,
                                   short& lmcchoppercycles, short& pmcchoppercycles)
{
  // find the train object for this time and fill the arguments
  table_train* tabletrain = NULL;
  if ((tabletrain = trainlist.GetTrain (searchtime, dataindex)) != NULL)
    tabletrain->GetData (chopperopensamples, chopperclosedsamples, lmcscalefactor, pmcscalefactor, lmcchoppercycles,
                         pmcchoppercycles);
}


bool table_train2_data :: Write ()
{
  bool iswritten = true;
  VOIDP bufferptrs [FIELDCOUNT];
  int* timedata = new int [TIME_FIELDS];
  short* traindata = new short [DATA_FIELDS];
  table_train* tabletrain = NULL;

  // while there are no errors and trains in the list
  while (iswritten && trainlist.GetNext (&tabletrain)) {

    // extract the data
    tabletrain->GetTime (timedata[0], timedata[1]);
    tabletrain->GetData (traindata[0], traindata[1], traindata[2], traindata[3], traindata[4], traindata[5]);

    // convert to bufferptrs
    bufferptrs [0] = &timedata [0];
    bufferptrs [1] = &timedata [1];
    bufferptrs [2] = &traindata [0];
    bufferptrs [3] = &traindata [1];
    bufferptrs [4] = &traindata [2];
    bufferptrs [5] = &traindata [3];
    bufferptrs [6] = &traindata [4];
    bufferptrs [7] = &traindata [5];

    if (! vdata.Write (bufferptrs))
      iswritten = false;
  }

  delete [] timedata;
  delete [] traindata;

  return iswritten;
}
