/********** TableTrain1Data.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "TableTrain1Data.h"
#include "LMCTableTrain.h"

int const table_train1_data::FIELDCOUNT                       = 6;
int const table_train1_data::DATA_FIELDS                      = (FIELDCOUNT - TIME_FIELDS);
int const table_train1_data::CHOPPER_OPEN_SAMPLES_OFFSET      = 6;
int const table_train1_data::CHOPPER_CLOSED_SAMPLES_OFFSET    = 8;
int const table_train1_data::LMC_SECTOR_CHOPPER_CYCLES_OFFSET = 14;

table_train1_data :: table_train1_data ()
                   : table_train_data ()
                   , trainlist ()
                   , vgroup ()
                   , vdata ()
{
  ;
}


table_train1_data :: ~table_train1_data ()
{
  ;
}


void table_train1_data :: AddPacket (mopitt_time const& packettime, unsigned char* packetdata)
{
  // get the table offsets
  int configoffset = GetConfigTableOffset (packetdata);
  int spmoffset = GetSPM1TableOffset (packetdata);

  // make a new train object with the data
  table_train* tabletrain = new lmc_table_train (packettime,
                                               ((packetdata[configoffset + SCALEFACTOR_LMC_24BIT_OFFSET] * 256) +
                                                (short) packetdata[configoffset + SCALEFACTOR_LMC_24BIT_OFFSET + 1]),
                                               GetSPMValue (packetdata[spmoffset + CHOPPER_OPEN_SAMPLES_OFFSET]),
                                               GetSPMValue (packetdata[spmoffset + CHOPPER_CLOSED_SAMPLES_OFFSET]),
                                               GetSPMValue (packetdata[spmoffset + LMC_SECTOR_CHOPPER_CYCLES_OFFSET]));

  // add the train object to the list
  trainlist.AddTrain (tabletrain);
}


bool table_train1_data :: Close ()
{
  bool isclosed = false;

  if (vdata.Close ())
    if (vgroup.Close ())
      isclosed = true;

  return isclosed;
}


bool table_train1_data :: Define (int32 fileid, int32 tableid)
{
  bool isdefined = false;

  if (vgroup.Create ("Table Train 1 Group", "Table Data Group", fileid))
    if (vdata.Create ("Table Train 1 Data", "Table Train Data", fileid)) {
      string const fieldnames [FIELDCOUNT] = {"Days", "Milliseconds", "Chopper Open Samples", "Chopper Closed Samples",
                                              "Scale Factor", "Chopper Cycles"};
      int32 datatypes [FIELDCOUNT] = {DFNT_INT32, DFNT_INT32, DFNT_INT16, DFNT_INT16, DFNT_INT16, DFNT_INT16};
      int32 orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1};
      if (vdata.Define (FIELDCOUNT, datatypes, orders, fieldnames))
        if (vdata.Set (FIELDCOUNT, fieldnames))
          if (vdata.Insert (vgroup.GetID ()))
            if (vgroup.Insert (tableid))
              isdefined = true;
    }

  return isdefined;
}


void table_train1_data :: GetData (mopitt_time const& searchtime, short& chopperopensamples,
                                   short& chopperclosedsamples, short& scalefactor, short& choppercycles)
{
  // find the train object for this time and fill the arguments
  table_train* tabletrain = NULL;
  if ((tabletrain = trainlist.GetTrain (searchtime, dataindex)) != NULL)
    tabletrain->GetData (chopperopensamples, chopperclosedsamples, scalefactor, choppercycles);
}


bool table_train1_data :: Write ()
{
  bool iswritten = true;
  VOIDP bufferptrs [FIELDCOUNT];
  int* timedata = new int [TIME_FIELDS];
  short* traindata = new short [DATA_FIELDS];
  table_train* tabletrain = NULL;

  // while there are no errors and trains in the list
  while (iswritten && trainlist.GetNext (&tabletrain)) {

    // extract the data
    tabletrain->GetTime (timedata[0], timedata[1]);
    tabletrain->GetData (traindata[0], traindata[1], traindata[2], traindata[3]);

    // convert to bufferptrs
    bufferptrs [0] = &timedata [0];
    bufferptrs [1] = &timedata [1];
    bufferptrs [2] = &traindata [0];
    bufferptrs [3] = &traindata [1];
    bufferptrs [4] = &traindata [2];
    bufferptrs [5] = &traindata [3];

    if (! vdata.Write (bufferptrs))
      iswritten = false;
  }

  delete [] timedata;
  delete [] traindata;

  return iswritten;
}
