/********** TableData.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "TableData.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const table_data::TRAIN_WARNING = 802;

table_data :: table_data ()
            : train1data (),
              train2data (),
              train3data (),
              train4data ()
{
  ;
}


table_data :: ~table_data ()
{
  ;
}


void table_data :: AddPacket (mopitt_time const& packettime, unsigned char* packetdata)
{
  train1data.AddPacket (packettime, packetdata);
  train2data.AddPacket (packettime, packetdata);
  train3data.AddPacket (packettime, packetdata);
  train4data.AddPacket (packettime, packetdata);
}


bool table_data :: Close ()
{
  bool isclosed = false;

  if (train1data.Close ())
    if (train2data.Close ())
      if (train3data.Close ())
        if (train4data.Close ())
          isclosed = true;

  return isclosed;
}


bool table_data :: Define (int32 fileid, int32 tableid)
{
  bool isdefined = false;

  if (train1data.Define (fileid, tableid))
    if (train2data.Define (fileid, tableid))
      if (train3data.Define (fileid, tableid))
        if (train4data.Define (fileid, tableid))
          isdefined = true;

  return isdefined;
}


bool table_data :: Write ()
{
  bool iswritten = false;

  if (train1data.Write ())
    if (train2data.Write ())
      if (train3data.Write ())
        if (train4data.Write ())
          iswritten = true;

  return iswritten;
}


void table_data :: GetData (int train, mopitt_time const& traintime, short& chopperopensamples, 
                            short& chopperclosedsamples, short& scalefactor, short& choppercycles)
{
  if (train == 1)
    train1data.GetData (traintime, chopperopensamples, chopperclosedsamples, scalefactor, choppercycles);
  else if (train == 3)
    train3data.GetData (traintime, chopperopensamples, chopperclosedsamples, scalefactor, choppercycles);
  else
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_TABLE_MODULE, TRAIN_WARNING, 0, 0, 0, 0, train, 0, 0,
                                 0, "Incorrect train number for lmc train earthview data retrieval");
}


void table_data :: GetData (int train, mopitt_time const& traintime, short& chopperopensamples, 
                            short& chopperclosedsamples, short& lmcscalefactor, short& pmcscalefactor, 
                            short& lmcchoppercycles, short& pmcchoppercycles)
{
  if (train == 2)
    train2data.GetData (traintime, chopperopensamples, chopperclosedsamples, lmcscalefactor, pmcscalefactor, 
                        lmcchoppercycles, pmcchoppercycles);
  else if (train == 4)
    train4data.GetData (traintime, chopperopensamples, chopperclosedsamples, lmcscalefactor, pmcscalefactor, 
                        lmcchoppercycles, pmcchoppercycles);
  else
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_TABLE_MODULE, TRAIN_WARNING, 0, 0, 0, 0, train, 0, 0,
                                 0, "Incorrect train number for lmcpmc train earthview data retrieval");
}


bool table_data :: Write (int32 fileid, int32 tableid)
{
  bool iswritten = false;

  if (Define (fileid, tableid))
    if (Write ())
      if (Close ())
        iswritten = true;

  return iswritten;
}
