/********** TableCollection.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   09/99   Charles Cavanaugh
   09/00   Daniel Ziskin
   07/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "TableCollection.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const table_collection::APID         = 196;
int const table_collection::PACKETSIZE   = 6166;
int const table_collection::PACKETLENGTH = PACKETSIZE - CCSDS_HEADER_LENGTH;
int const table_collection::APID_ERROR   = 900;
int const table_collection::LENGTH_ERROR = 901;

table_collection :: table_collection ()
                  : l0_collection (TABLE_COLLECTION_01_LOGICAL, PACKETSIZE)
{
  ;
}


table_collection :: ~table_collection ()
{
  ;
}


table_packet* table_collection :: GetPacket ()
{
  table_packet* tablepacket = NULL;
  PGSt_IO_L0_Packet* data;
  static int oldsequence = -1;

  // while still searching for a valid packet
  bool keeplooking = true;
  while (keeplooking) {

    // get a l0 packet
    data = new PGSt_IO_L0_Packet [PACKETSIZE];
    if (! l0_collection::GetPacket (data)) {
      delete [] data;
      keeplooking = false;
    }
    else {
 
      // make a new table packet
      tablepacket = new table_packet (data);
      int sequence = tablepacket->GetSequence ();

      // if the apids or lengths dont match, delete the packet, else stop looking
      if (tablepacket->GetAPID () != APID) {
        string message = tablepacket->MakeWrongAPIDMessage ();
        delete tablepacket;
        tablepacket = NULL;
        diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_TABLE_MODULE, APID_ERROR, GetCurrentLogical (), 0,
                                     sequence, 0, 0, 0, 0, 0, message);
      }
      else if (tablepacket->GetLength () != PACKETLENGTH) {
        string message = tablepacket->MakeWrongLengthMessage ();
        delete tablepacket;
        tablepacket = NULL;
        diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_TABLE_MODULE, LENGTH_ERROR, GetCurrentLogical (), 
                                     0, sequence, 0, 0, 0, 0, 0, message);
      }
      else {
        keeplooking = false;
        if ((tablepacket->SequenceGap (oldsequence, sequence)) && (oldsequence >= 0)) {
          string message = tablepacket->MakeSequenceGapMessage (oldsequence, sequence);
          diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_TABLE_MODULE,
                                       tablepacket->GetSequenceErrCode (), GetCurrentLogical (), 0, sequence, 0, 0, 0, 
                                       0, 0, message);
        }
        oldsequence = sequence;
      }
    }
  }

  return tablepacket;
}


void table_collection :: Ingest ()
{
  table_packet* tablepacket;
  unsigned char* packetdata;

  // while there are packets in the file(s), add them to the data container
  while ((tablepacket = GetPacket ()) != NULL) {
    packetdata = tablepacket->GetPacketData ();
    tabledata.AddPacket (tablepacket->GetTime (), packetdata);
    delete [] packetdata;
    delete tablepacket;
  }
}


void table_collection :: GetData (int train, mopitt_time const& traintime, short& chopperopensamples, 
                                  short& chopperclosedsamples, short& scalefactor, short& choppercycles)
{
  tabledata.GetData (train, traintime, chopperopensamples, chopperclosedsamples, scalefactor, choppercycles);
}


void table_collection :: GetData (int train, mopitt_time const& traintime, short& chopperopensamples, 
                                  short& chopperclosedsamples, short& lmcscalefactor, short& pmcscalefactor, 
                                  short& lmcchoppercycles, short& pmcchoppercycles)
{
  tabledata.GetData (train, traintime, chopperopensamples, chopperclosedsamples, lmcscalefactor, 
                     pmcscalefactor, lmcchoppercycles, pmcchoppercycles);
}


bool table_collection :: Write (int32 fileid, int32 tableid)
{
  return tabledata.Write (fileid, tableid);
}
