/********** SwathTimes.h **********************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_TIMES_

  #define _MOPITT_L1_SWATH_TIMES_

  #include "HDFSwathGeolocationDataset.h"
  #include "MOPITTTime.h"
  #include "SwathConstants.h"

  class swath_times {
    private :
      static int const DATASET_DIMENSIONS;

      static hdf_swath_geolocation_dataset dataset;

      mopitt_time times [SWATH_STARES];
      bool        setstart;
      int         startindex;
      int         stopindex;

    protected :

    public :
      swath_times ();
      ~swath_times ();

      bool               Define       (hid_t);
      mopitt_time        GetStartTime () const;
      mopitt_time        GetStopTime  () const;
      mopitt_time const& GetTime      (int stare) const {return times [stare];}
      void               Set          (int, mopitt_time const&);
      bool               Write        (hid_t, int);
  };

#endif
