/********** SwathTimes.C **********************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "SwathTimes.h"

int const swath_times::DATASET_DIMENSIONS = 1;
hdf_swath_geolocation_dataset swath_times::dataset;

swath_times :: swath_times ()
{
  setstart = true;
  startindex = -1;
  stopindex = -1;
}


swath_times :: ~swath_times ()
{
  ;
}


bool swath_times :: Define (hid_t dataid)
{
  hsize_t const sizes [DATASET_DIMENSIONS] = { DIM_TMP_TRACK };
  string const names [DATASET_DIMENSIONS] = { "ntrack" };
  string const units = "s";  
  return dataset.Define (dataid, "Time",   H5T_NATIVE_DOUBLE, DATASET_DIMENSIONS, sizes, names, units);
}


mopitt_time swath_times :: GetStartTime () const
{
  mopitt_time starttime;

  if (startindex < 0)
    starttime.Set (0.0);
  else
    starttime = times [startindex];

  return starttime;
}


mopitt_time swath_times :: GetStopTime () const
{
  mopitt_time stoptime;

  if (stopindex < 0)
    stoptime.Set (0.0);
  else
    stoptime.Set (times [stopindex] .GetTAI () + ((double) SWATH_STARE_MSECS_GAP / 1000.0));

  return stoptime;
}


void swath_times :: Set (int stare, mopitt_time const& newtime)
{
  times [stare] = newtime;
  stopindex = stare;
  if (setstart) {
    startindex = stare;
    setstart = false;
  }
}


bool swath_times :: Write (hid_t dataid, int trackindex)
{
  double starttai = (GetStartTime ()).GetTAI ();
  return dataset.Write (dataid, trackindex, (VOIDP) &starttai);
}
