/********** SwathRadiances.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   03/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao
   10/09   Debbie Mao -- add L0 std dev

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_RADIANCES_

  #define _MOPITT_L1_SWATH_RADIANCES_

  #include "HDFSwathDataDataset.h"
  #include "ScienceConstants.h"
  #include "SwathConstants.h"
  #include "SwathFlags.h"
  #include "SwathTimes.h"
  #include "SwathPacketPositions.h"
  #include "CalibrationHistories.h"

  class swath_radiances {
    private :
      static int const RADIANCE_DATASET_DIMENSIONS;
      static int const CALIBRATION_DATASET_DIMENSIONS;
      static int const CALIBRATION_SECTOR_DIMENSIONS;
      static int const NOTPRESENT_VERBOSE;
      static int const INVALID_VERBOSE;
      static int const SOLARNIGHT_VERBOSE;
      static int const SIGNALINFO_VERBOSE;
      static int const MISSING_WARNING;
      static int const NEGATIVE_WARNING;

      static hdf_swath_data_dataset radiancedataset;
      static hdf_swath_data_dataset calibrationdataset;
      static hdf_swath_data_dataset calibrationsectordataset;
      static hdf_swath_data_dataset level0sddataset;

      int    lastcell          [SWATH_STARES] [SWATH_CHANNELS];
      double signals           [SWATH_STARES] [SWATH_CHANNELS] [SWATH_PIXELS]             [SWATH_SAWTOOTH_SET];
      float  radiances         [SWATH_STARES] [SWATH_PIXELS]   [SWATH_CHANNELS]           [SWATH_RADIANCE_STATES];
      float  calibration       [SWATH_PIXELS] [SWATH_CHANNELS] [SWATH_CALIBRATION_STATES] [SWATH_CALIBRATION_TERMS];
      float  calibrationAD     [SWATH_PIXELS] [SWATH_CHANNELS] [SWATH_RADIANCE_STATES]    [SWATH_CALIBRATION_TERMS];
      float  calibrationsector [SWATH_PIXELS] [SWATH_CHANNELS] [SWATH_LMC_SECTORS]        [SWATH_CALIBRATION_TERMS];
      float  level0sd          [SWATH_STARES] [SWATH_PIXELS]   [SWATH_CHANNELS]           [SWATH_RADIANCE_STATES];

      void OutputSignalInfo (mopitt_time const&, int, int, int, int, double const [SWATH_SAWTOOTH_SET]);

    protected :

    public :
      swath_radiances ();
      ~swath_radiances ();

      void AddLastcellState       (int, int [SWATH_CHANNELS]) const;
      void AddSignals             (int, double const [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET])
                                   const;
      void Calibrate              (swath_flags const&, swath_times const&, swath_packetpositions, 
                                   calibration_histories&, int, processor_parameters const&);
      bool Define                 (hid_t);
      bool Write                  (hid_t, int);
      void CalculateSawtooth      (int, int, int, int [SWATH_SAWTOOTH_SET],  double [SWATH_SAWTOOTH_SET],
				   int [SWATH_SAWTOOTH_SET] );
      void CalculateTriplets      (int [SWATH_SAWTOOTH_SET ], double [SWATH_SAWTOOTH_SET], double [SWATH_TRIPLET_SET ],
                                   double [SWATH_TRIPLET_SET ], double [SWATH_TRIPLET_SET ], int& );
      void GetADSectorCalibration ( );  
  };

#endif
