/********** SwathPacketPositions.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
 03/01 - Created by Ziskin by copying SwathEngineering.C

 $Log$

\**********************************************************************************************************************/

#include "SwathPacketPositions.h"

int const swath_packetpositions::DATASET_DIMENSIONS = 2;

hdf_swath_data_dataset swath_packetpositions::dataset;

swath_packetpositions :: swath_packetpositions ()
{
  for (int posterm = 0; posterm < SWATH_STARES; posterm++)
      packetpositions [posterm] = SWATH_MISSING_INT;
}


swath_packetpositions :: ~swath_packetpositions ()
{
  ;
}


bool swath_packetpositions :: Define (hid_t dataid)
{
  hsize_t const sizes [DATASET_DIMENSIONS] = { DIM_TMP_TRACK, DIM_STARES };
  string const names [DATASET_DIMENSIONS] = { "ntrack", "nstare" };
  string const units = "NA";
  return dataset.Define (dataid, "PacketPositions", H5T_NATIVE_INT, DATASET_DIMENSIONS, sizes, names, units);
}


bool swath_packetpositions :: Write (hid_t dataid, int trackindex)
{
  return dataset.Write (dataid, trackindex, (VOIDP) packetpositions);
}


void swath_packetpositions :: Collect (int stareindex, int const starenumber)
{
  packetpositions [stareindex]  = starenumber;
}




