/********** SwathNoise.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_NOISE_

  #define _MOPITT_L1_SWATH_NOISE_

  #include "HDFSwathDataDataset.h"
  #include "SwathConstants.h"
  #include "CalibrationHistories.h"
  #include "mfhdf.h"

  class swath_noise {
    private :
      static const int DATASET_DIMENSIONS;
      static const int DAY_DATASET_DIMENSIONS;      

      static hdf_swath_data_dataset dataset;
      static hdf_swath_data_dataset dnoisedataset;
      static hdf_swath_data_dataset dgaindataset;      

      float positionnoise   [SWATH_PIXELS] [SWATH_PMC_CHANNELS] [SWATH_POS_NOISE_STATES] [SWATH_PACKETPOSITION];
      float dailymeannoise  [SWATH_PIXELS] [SWATH_CHANNELS] [SWATH_POS_NOISE_STATES];
      float dailygaindev    [SWATH_PIXELS] [SWATH_CHANNELS] [SWATH_POS_NOISE_STATES];

    protected :

    public :
      swath_noise ();
      ~swath_noise ();

      bool Define   (hid_t);
      bool Write    (hid_t, int, int&);
      void GetData  (calibration_histories&);
  };

#endif










