/********** SwathNoise.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
  05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "SwathNoise.h"
#include <memory.h>
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const swath_noise::DATASET_DIMENSIONS = 4;
int const swath_noise::DAY_DATASET_DIMENSIONS = 3;

hdf_swath_data_dataset swath_noise::dataset;
hdf_swath_data_dataset swath_noise::dnoisedataset;
hdf_swath_data_dataset swath_noise::dgaindataset;

int const WRITE_ERROR = 913;

swath_noise :: swath_noise ()
{
  for (int pixel = 0; pixel < SWATH_PIXELS; pixel++) 
    for (int channel = 0; channel < SWATH_PMC_CHANNELS; channel++)
      for ( int nstate = 0; nstate < SWATH_POS_NOISE_STATES; nstate++ ){
	dailymeannoise [pixel] [channel] [nstate] =0;
	dailygaindev [pixel] [channel] [nstate] =0;
	for ( int position =0; position < SWATH_PACKETPOSITION; position++ )
	  positionnoise [pixel] [channel] [nstate] [position] = SWATH_MISSING_VALUE;
      }
}


swath_noise :: ~swath_noise ()
{
  ;
}


bool swath_noise :: Define (hid_t dataid)
{
  bool isdefined = false;
  
  hsize_t const sizes [DATASET_DIMENSIONS] = { DIM_PIXELS, DIM_PMC_CHANNELS,
					       DIM_RADIANCE_STATES, DIM_PACKETPOSITION }; 
  string const names [DATASET_DIMENSIONS] = {"npixels", "npchan", "nstate", "nposition"};
  string const units = "W/m^2str";

  hsize_t const daysizes [DAY_DATASET_DIMENSIONS] = { DIM_PIXELS, DIM_CHANNELS, DIM_RADIANCE_STATES }; 
  string  const daynames [DAY_DATASET_DIMENSIONS] = {"npixels", "nchan", "nstate"};
  
  if (dataset.Define (dataid, "DailyMeanPositionNoise", H5T_NATIVE_FLOAT, DATASET_DIMENSIONS, sizes, names, units))
    if (dnoisedataset.Define (dataid, "DailyMeanNoise", H5T_NATIVE_FLOAT, DAY_DATASET_DIMENSIONS, daysizes, daynames, units))
      if (dgaindataset.Define (dataid, "DailyGainDev",  H5T_NATIVE_FLOAT, DAY_DATASET_DIMENSIONS, daysizes, daynames, units))
	isdefined = true;

  return isdefined;
}


bool swath_noise :: Write (hid_t dataid, int trackindex, int& iswritten)
{
  hssize_t start[4];
  hsize_t  edge[4];
  bool written = true;

  if ( iswritten == 0) {
    start[0]=0;            start[1]=0;                  start[2]=0;                      start[3]=0; 
    edge[0] =SWATH_PIXELS; edge [1]=SWATH_PMC_CHANNELS; edge [2]=SWATH_POS_NOISE_STATES; edge [3]=SWATH_PACKETPOSITION;

    if (HE5_SWwritefield (dataid, "DailyMeanPositionNoise", start, NULL, edge, positionnoise) == FAIL) {
      written = false;
      string message = "Could not write to dataset ";
      message += "Daily Mean Position Noise";
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_SWATH_MODULE, WRITE_ERROR, 0, (trackindex + 1), 0, 0,
				   0, 0, 0, 0, message);
    }
    iswritten = 1;
  }
  return written;
}


void swath_noise :: GetData (calibration_histories& calhistories )
{
  float posnoise [SWATH_PMC_CHANNELS] [SWATH_PIXELS] [SWATH_POS_NOISE_STATES] [SWATH_PACKETPOSITION] ;
  calhistories.GetNoiseData ( posnoise);
  
  for (int channel = 0; channel < SWATH_PMC_CHANNELS; channel++)
    for ( int pixel = 0; pixel < SWATH_PIXELS; pixel++)    
      (void) memcpy ( (void*) positionnoise [pixel] [channel], (const void*) posnoise [channel] [pixel],
		     sizeof (float [SWATH_POS_NOISE_STATES] [SWATH_PACKETPOSITION]) ); 
}
