/********** SwathLocation.h *******************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_LOCATION_

  #define _MOPITT_L1_SWATH_LOCATION_

  #include "PGS_TD.h"
  #include "HDFSwathDataDataset.h"
  #include "HDFSwathGeolocationDataset.h"
  #include "SwathConstants.h"
  #include "SwathFlags.h"
  #include "SwathTimes.h"
  #include "MOPIPFile.h"
  #include "HDFSwathGroup.h"


  class swath_location {
    private :
      static int const    DATASET_DIMENSIONS;
      static int const    LATLON_WARNING;
      static int const    SUNECR_WARNING;
      static int const    ZENITHAZIMUTH_WARNING;
      static double const DEGREES_IN_RADIAN;

      static hdf_swath_geolocation_dataset latitudedataset;
      static hdf_swath_geolocation_dataset longitudedataset;
      static hdf_swath_data_dataset        solarzenithdataset;
      static hdf_swath_data_dataset        solarazimuthdataset;
      static hdf_swath_data_dataset        satellitezenithdataset;
      static hdf_swath_data_dataset        satelliteazimuthdataset;

      float latitude         [SWATH_STARES] [SWATH_PIXELS];
      float longitude        [SWATH_STARES] [SWATH_PIXELS];
      float solarzenith      [SWATH_STARES] [SWATH_PIXELS];
      float solarazimuth     [SWATH_STARES] [SWATH_PIXELS];
      float satellitezenith  [SWATH_STARES] [SWATH_PIXELS];
      float satelliteazimuth [SWATH_STARES] [SWATH_PIXELS];

      bool GetLatLon        (string const&, PGSt_double [SWATH_PIXELS], PGSt_double [SWATH_PIXELS][VECTOR_LENGTH], 
                             PGSt_double [SWATH_PIXELS], PGSt_double [SWATH_PIXELS], 
                             PGSt_double [SWATH_PIXELS][VECTOR_LENGTH]) const;
      bool GetSunECR        (string const&, PGSt_double [SWATH_PIXELS], PGSt_double [SWATH_PIXELS][VECTOR_LENGTH]) 
                             const;
      bool GetZenithAzimuth (PGSt_double [SWATH_PIXELS], PGSt_double [SWATH_PIXELS], 
                             PGSt_double [SWATH_PIXELS][VECTOR_LENGTH], PGSt_tag, float [SWATH_PIXELS], 
                             float [SWATH_PIXELS], bool [SWATH_PIXELS]) const;

    protected :

    public :
      swath_location ();
      ~swath_location ();

      void GeoLocate (swath_flags&, swath_times const&, mopip_file const&, int);
      bool Define    (hid_t);
      //bool Define    (hdf_swath_group&);
      bool Write     (hid_t, int);
  };

#endif
