/********** SwathFlags.h **********************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_FLAGS_

  #define _MOPITT_L1_SWATH_FLAGS_

  #include "HDFSwathDataDataset.h"
  #include "SwathConstants.h"

  class swath_flags {
    private :
      static int const DATASET_DIMENSIONS;
      static int const INVALIDATE_WARNING;

      static hdf_swath_data_dataset dataset;
      static hdf_swath_data_dataset flagset;

      bool present   [SWATH_STARES];
      bool night     [SWATH_STARES] [SWATH_PIXELS];
      bool invalid   [SWATH_STARES] [SWATH_CHANNELS] [SWATH_PIXELS];
      int  ch7flag;
      
    protected :

    public :
      swath_flags ();
      ~swath_flags ();

      bool Define        (hid_t);
      int  GetStareCount () const;
      void Invalidate    (bool const [SWATH_CHANNELS], int);
      bool IsInvalid     (int stare, int channel, int pixel) const {return invalid [stare] [channel] [pixel];}
      bool IsNight       (int stare, int pixel) const { return night [stare] [pixel];}
      bool IsPresent     (int stare) const {return present [stare];}
      void SetInvalid    (int, bool);
      void SetInvalid    (int, int, bool);
      void SetInvalid    (int, int, int, bool);
      void SetNight      (int, bool);
      void SetNight      (int, int, bool);
      void SetPresent    (int, bool);
      bool Write         (hid_t, int);
  };

#endif
