/********** SwathFlags.C **********************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include "SwathFlags.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const swath_flags::DATASET_DIMENSIONS = 1;
int const swath_flags::INVALIDATE_WARNING = 805;

hdf_swath_data_dataset swath_flags::dataset;
hdf_swath_data_dataset swath_flags::flagset;

swath_flags :: swath_flags ()
{
  for (int stare = 0; stare < SWATH_STARES; stare++) {
    present [stare] = false;
    for (int pixel = 0; pixel < SWATH_PIXELS; pixel++) {
      night [stare] [pixel] = false;
      for (int channel = 0; channel < SWATH_CHANNELS; channel++)
        invalid [stare] [channel] [pixel] = false;
    }
  }
  ch7flag = 0;
}


swath_flags :: ~swath_flags ()
{
  ;
}


bool swath_flags :: Define (hid_t dataid)
{
  hsize_t const sizes [DATASET_DIMENSIONS] = { DIM_TMP_TRACK };
  string const names [DATASET_DIMENSIONS] = { "ntrack" };
  string const units = "NA";
  if ( dataset.Define (dataid, "SwathQuality", H5T_NATIVE_INT, DATASET_DIMENSIONS, sizes, names, units) )
    return flagset.Define (dataid, "Ch7Invalid", H5T_NATIVE_INT, DATASET_DIMENSIONS, sizes, names, units);  
}


int swath_flags :: GetStareCount () const
{
  int starecount = 0;
  for (int i = 0; i < SWATH_STARES; i++)
    if (present [i])
      starecount++;
  return starecount;
}


void swath_flags :: Invalidate (bool const invalidators [SWATH_CHANNELS], int tracknumber)
{
  for (int channel = 0; channel < SWATH_CHANNELS; channel++)
    if (invalidators [channel]) {
      if ( channel > 3 ) {
	diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_SWATH_MODULE, INVALIDATE_WARNING, 0, tracknumber,
				     0, 0, 0, (channel + 1), 0, 0, 
				     "Radiances invalidated due to out-of-bounds engineering data");
      }
      for (int stare = 0; stare < SWATH_STARES; stare++)
        for (int pixel = 0; pixel < SWATH_PIXELS; pixel++)
          invalid [stare] [channel] [pixel] = true;
    }
  if (invalidators [6])
    ch7flag = 1;
}
  

void swath_flags :: SetInvalid (int stare, bool value)
{
  for (int channel = 0; channel < SWATH_CHANNELS; channel++)
    for (int pixel = 0; pixel < SWATH_PIXELS; pixel++)
      invalid [stare] [channel] [pixel] = value;
}


void swath_flags :: SetInvalid (int stare, int channel, bool value)
{
  for (int pixel = 0; pixel < SWATH_PIXELS; pixel++)
    invalid [stare] [channel] [pixel] = value;
}


void swath_flags :: SetInvalid (int stare, int channel, int pixel, bool value)
{
  invalid [stare] [channel] [pixel] = value;
}


void swath_flags :: SetNight (int stare, bool value)
{
  for (int pixel = 0; pixel < SWATH_PIXELS; pixel++)
    night [stare] [pixel] = value;
}


void swath_flags :: SetNight (int stare, int pixel, bool value)
{
  night [stare] [pixel] = value;
}


void swath_flags :: SetPresent (int stare, bool value)
{
  present [stare] = value;
}


bool swath_flags :: Write (hid_t dataid, int trackindex)
{
  // write the present flag as a 32-bit number
  int quality = 0;
  for (int stare = 0; stare < SWATH_STARES; stare++)
    if (present [stare])
      quality |= (int) pow (2.0, (double) stare);
  if( dataset.Write (dataid, trackindex, (VOIDP) &quality) )
    return flagset.Write (dataid, trackindex, (VOIDP) &ch7flag);  
}
