/********** SwathEngineering.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_ENGINEERING_

  #define _MOPITT_L1_SWATH_ENGINEERING_

  #include "HDFSwathDataDataset.h"
  #include "SwathConstants.h"
  #include "SwathTimes.h"
  #include "EngineeringCollection.h"
  #include "MOPIPFile.h"

  class swath_engineering {
    private :
      static const int DATASET_DIMENSIONS;

      static hdf_swath_data_dataset dataset;

      float engineering [SWATH_ENGINEERING_TERMS] [SWATH_ENGINEERING_STATES];

    protected :

    public :
      swath_engineering ();
      ~swath_engineering ();

      void Collect (swath_times const&, engineering_collection&, mopip_file const&);
      bool Define  (hid_t);
      bool Write   (hid_t, int);
  };

#endif
