/********** SwathEngineering.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "SwathEngineering.h"

int const swath_engineering::DATASET_DIMENSIONS = 3;

hdf_swath_data_dataset swath_engineering::dataset;

swath_engineering :: swath_engineering ()
{
  for (int engterm = 0; engterm < SWATH_ENGINEERING_TERMS; engterm++)
    for (int engstate = 0; engstate < SWATH_ENGINEERING_STATES; engstate++)
      engineering [engterm] [engstate] = SWATH_MISSING_VALUE;
}


swath_engineering :: ~swath_engineering ()
{
  ;
}


void swath_engineering :: Collect (swath_times const& times, engineering_collection& engineeringcollection, 
                                   mopip_file const& mopipfile)
{
  engineeringcollection.GetSwathData (times.GetStartTime (), times.GetStopTime (), mopipfile, engineering);
}


bool swath_engineering :: Define (hid_t dataid)
{
  hsize_t const sizes [DATASET_DIMENSIONS] = { DIM_TMP_TRACK, DIM_ENGINEERING_TERMS, DIM_ENGINEERING_STATES };
  string const names [DATASET_DIMENSIONS] = { "ntrack", "nengpoints", "neng" };
  string units = "K or kPa";
  return dataset.Define (dataid, "EngineeringData", H5T_NATIVE_FLOAT, DATASET_DIMENSIONS, sizes, names, units);
}


bool swath_engineering :: Write (hid_t dataid, int trackindex)
{
  return dataset.Write (dataid, trackindex, (VOIDP) engineering);
}
