/********** SwathData.h ***********************************************************************************************\

 $Header$

 REVISION HISTORY

   09/12   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_DATA_

  #define _MOPITT_L1_SWATH_DATA_

  #include "HDFSwathGroup.h"
  #include "SwathTimes.h"
  #include "SwathLocation.h"
  #include "SwathEngineering.h"
  #include "SwathRadiances.h"
  #include "SwathPacketPositions.h"
  #include "SwathFlags.h"
  #include "SwathNoise.h"
  #include "CalibrationHistories.h"
  #include "EngineeringCollection.h"
  #include "MOPIPFile.h"
  #include "ProcessorParameters.h"

  class swath_data {
    private :
      static bool ismetadataretrieved;

      int                   trackindex;
      swath_times           times;
      swath_location        location;
      swath_engineering     engineering;
      swath_radiances       radiances;
      swath_flags           flags;
      swath_packetpositions packetpositions;
      swath_noise           noise;

      void RetrieveMetadata (calibration_histories&) const;
      void WriteInfo        () const;

    protected :

    public :
      swath_data ();
      swath_data (int);
      ~swath_data ();

      void        AddTime                (int, mopitt_time const&);
      void        Calibrate              (calibration_histories&, processor_parameters const& );
      void        CollectEngineering     (engineering_collection&, mopip_file const&);
      void        AddSignals             (int, double const [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const;
      void        CollectPacketPositions (int, int const );
      void        GetNoise               (calibration_histories&, int&);
      bool        Define                 (hid_t, hdf_swath_group&);
      void        GeoLocate              (mopip_file const&);
      mopitt_time GetStartTime           () const {return times.GetStartTime ();}
      mopitt_time GetStopTime            () const {return times.GetStopTime ();}
      void        Invalidate             (bool const [SWATH_CHANNELS]);
      bool        Write                  (hdf_swath_group&, int&);
      void        AddLastcellState       (int, int [SWATH_CHANNELS]) const ;
  };

#endif

