/********** SwathData.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   05/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   03/01   Ziskin
   10/01   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "PGS_SMF.h"
#include "SwathData.h"
#include "MOP01GlobalMetadata.h"

bool swath_data::ismetadataretrieved = false;

swath_data :: swath_data ()
            : times (),
              location (),
              engineering (),
              radiances (),
              flags (),
	      packetpositions ()
{
  trackindex = 0;
}


swath_data :: swath_data (int index)
            : times (),
              location (),
              engineering (),
              radiances (),
              flags (),
	      packetpositions ()
{
  trackindex = index;
}


swath_data :: ~swath_data ()
{
  ;
}


void swath_data :: RetrieveMetadata (calibration_histories& calhistories ) const
{
  mopitt_time prehot1, prehot2, prehot3, prehot4, posthot1, posthot2, posthot3, posthot4;
  calhistories.GetHotBracketingTimes (times.GetStartTime (), prehot1, prehot2, prehot3, prehot4, posthot1, posthot2, 
                                      posthot3, posthot4);
  extern mop01_global_metadata mop01globalmetadata;
  mop01globalmetadata.SetTimes (prehot1, prehot2, prehot3, prehot4, posthot1, posthot2, posthot3, posthot4);
}


void swath_data :: WriteInfo () const
{
  char info [130];
  (void) sprintf (info, "Earth view for track %d : %d stares, %s start time, %s stop time", (trackindex + 1),
                  flags.GetStareCount (), ((times.GetStartTime ()).GetUTC ()).c_str (),
                  ((times.GetStopTime ()).GetUTC ()).c_str ());
  (void) PGS_SMF_GenerateStatusReport (info);
}


void swath_data :: AddTime (int stareindex, mopitt_time const& newtime)
{
  times.Set (stareindex, newtime);
  flags.SetPresent (stareindex, true);
}


void swath_data :: Calibrate (calibration_histories& calhistories, processor_parameters const& processorparameters )
{
  radiances.Calibrate (flags, times, packetpositions, calhistories, (trackindex + 1), processorparameters);
  if (! ismetadataretrieved) {
    ismetadataretrieved = true;
    RetrieveMetadata (calhistories);
  }
}


void swath_data :: CollectEngineering (engineering_collection& engineeringcollection, mopip_file const& mopipfile)
{
  engineering.Collect (times, engineeringcollection, mopipfile);
}


void swath_data :: AddSignals (int stareindex, 
                               double const staresignals [SWATH_CHANNELS] [SWATH_PIXELS] [SWATH_SAWTOOTH_SET]) const
{
  radiances.AddSignals (stareindex, staresignals);   
}


void swath_data :: AddLastcellState (int stareindex, int starelastcell [SWATH_CHANNELS] ) const
{
  radiances.AddLastcellState (stareindex, starelastcell );
}


void swath_data :: CollectPacketPositions ( int stareindex, int const starenumber )
{
  packetpositions.Collect (stareindex, starenumber );
}


void swath_data :: GetNoise (calibration_histories& calhistories, int& isget )
{
  if ( isget == 0 ) {
    noise.GetData (calhistories);
    isget = 1;
  }
}


bool swath_data :: Define (hid_t fileid, hdf_swath_group& swathgroup)
{
  bool isdefined = false;

  // retrieve the group id
  hid_t groupid = swathgroup.GetID ();
 
  // define all the component datasets and attributes
  if (times.Define (groupid))
    if (location.Define (groupid))
      if (engineering.Define (groupid))
        if (radiances.Define (groupid))
          if (flags.Define (groupid))
	    if (packetpositions.Define (groupid)) 
	      if (noise.Define (groupid)) {

		// define the global attributes
		int trackcount = 0;
		if (swathgroup.WriteAttribute ("TrackCount", H5T_NATIVE_INT, (VOIDP) &trackcount)) {
		  float missingvalue = SWATH_MISSING_VALUE;
		  if (swathgroup.WriteAttribute ("missing_nodata", H5T_NATIVE_FLOAT, (VOIDP) &missingvalue)) {
		    float invalidvalue = SWATH_INVALID_VALUE;
		    if (swathgroup.WriteAttribute ("missing_invalid", H5T_NATIVE_FLOAT, (VOIDP) &invalidvalue)) {
		      // define dimension scales
		      if (swathgroup.defDS () != FAIL)
			// set the definitions (by resetting the group id)
			if (swathgroup.Reset (fileid))
			  isdefined = true;
		    }
		  }
		}
	      }
  
  return isdefined;
}


void swath_data :: GeoLocate (mopip_file const& mopipfile)
{
  location.GeoLocate (flags, times, mopipfile, (trackindex + 1));
}


void swath_data :: Invalidate (bool const invalidators [SWATH_CHANNELS])
{
  flags.Invalidate (invalidators, (trackindex + 1));
}


bool swath_data :: Write (hdf_swath_group& swathgroup, int& iswritten )
{
  // retrieve the group id
  hid_t groupid = swathgroup.GetID ();

  // write the data to the datasets
  if (times.Write (groupid, trackindex))
    if (location.Write (groupid, trackindex))
      if (engineering.Write (groupid, trackindex))
        if (radiances.Write (groupid, trackindex))
          if (flags.Write (groupid, trackindex))
	    if (packetpositions.Write (groupid, trackindex)) 
	      if (noise.Write (groupid, trackindex, iswritten)) {
		
		int trackcount = trackindex + 1;
		if (swathgroup.WriteAttribute ("TrackCount", H5T_NATIVE_INT, (VOIDP) &trackcount)) {
		  iswritten = true;
		  WriteInfo ();
		}
	      }
  
  return iswritten;
}
