/********** SwathConstants.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   04/99   Charles Cavanaugh
   06/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SWATH_CONSTANTS_

  #define _MOPITT_L1_SWATH_CONSTANTS_

  #include "CalibrationConstants.h"
  #include "EngineeringDataConstants.h"
  #include "ScienceConstants.h"
  #include "HE5_HdfEosDef.h"

  int   const SWATH_CALIBRATION_TERMS   = CALIBRATION_TERMS;
  int   const SWATH_CALIBRATION_STATES  = CALIBRATION_STATES;
  int   const SWATH_LMC_SECTORS         = LMC_SECTORS;
  int   const SWATH_CHANNELS            = SCIENCE_CHANNELS;
  int   const SWATH_ENGINEERING_STATES  = ENGINEERING_STATES;
  int   const SWATH_ENGINEERING_TERMS   = ENGINEERING_SWATH_VALUES;
  float const SWATH_INVALID_VALUE       = -8888.0;
  float const SWATH_MISSING_VALUE       = SCIENCE_MISSING_VALUE;
  int   const SWATH_MISSING_INT         = (int) (SCIENCE_MISSING_VALUE + 0.5);
  int   const SWATH_PIXELS              = SCIENCE_PIXELS;
  int   const SWATH_RADIANCE_STATES     = 2;
  int   const SWATH_SAWTOOTH_SET        = 16;
  int   const SWATH_TRIPLET_SET         = 14;
  int   const SWATH_STARES              = SCIENCE_STARES;
  int   const SWATH_STARE_MSECS_GAP     = STARE_MSECS_GAP;
  int   const SWATH_TRAINS              = SCIENCE_TRAINS;
  int   const SWATH_PACKETPOSITION      = SCIENCE_PACKETPOSITION;
  int   const SWATH_PMC_STATES          = PMC_SIGNAL_STATES;
  int   const SWATH_POS_NOISE_STATES    = 2;
  int   const SWATH_PMC_CHANNELS        = 2;

  hsize_t const DIM_TMP_TRACK           = 1;
  hsize_t const DIM_STARES              = 29;
  hsize_t const DIM_PIXELS              = 4;
  hsize_t const DIM_CHANNELS            = 8;
  hsize_t const DIM_RADIANCE_STATES     = 2;
  hsize_t const DIM_ENGINEERING_TERMS   = 34;
  hsize_t const DIM_ENGINEERING_STATES  = 2;
  hsize_t const DIM_LMC_SECTORS         = 4;
  hsize_t const DIM_CALIBRATION_TERMS   = 8;
  hsize_t const DIM_PMC_CHANNELS        = 2;
  hsize_t const DIM_PACKETPOSITION      = 5;


  enum swath_calibration_term         { SWATH_CALIBRATION_GAIN_MEAN,      SWATH_CALIBRATION_OFFSET_MEAN,
                                        SWATH_CALIBRATION_NOISE_MEAN,     SWATH_CALIBRATION_RADIANCE_MEAN,
                                        SWATH_CALIBRATION_GAIN_VARIANCE,  SWATH_CALIBRATION_OFFSET_VARIANCE,
                                        SWATH_CALIBRATION_NOISE_VARIANCE, SWATH_CALIBRATION_RADIANCE_VARIANCE };

  enum swath_lmc_sector_offsets       { SWATH_LMC_A_SECTOR, SWATH_LMC_B_SECTOR, SWATH_LMC_C_SECTOR, SWATH_LMC_D_SECTOR };

  enum swath_calibration_state_offset { SWATH_CALIBRATION_STATE_AVERAGE,  SWATH_CALIBRATION_STATE_DIFFERENCE, 
					SWATH_CALIBRATION_A_SECTOR,       SWATH_CALIBRATION_B_SECTOR,
					SWATH_CALIBRATION_C_SECTOR,       SWATH_CALIBRATION_D_SECTOR   };

  enum swath_radiance_state           { SWATH_RADIANCE_AVERAGE, SWATH_RADIANCE_DIFFERENCE }; 
  enum swath_pmc_states               { SWATH_PMC_AVERAGE, SWATH_PMC_DIFFERENCE }; 
  enum swath_pos_noise_state_offset   { SWATH_POSITION_NOISE_AVERAGE,  SWATH_POSITION_NOISE_DIFFERENCE };

#endif
