/********** ScienceTrainList.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrainList.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

science_train_list :: science_train_list ()
                    : trains ()
{
  ResetNext ();
}


science_train_list :: ~science_train_list ()
{
  Empty ();
}


void science_train_list :: AddTrain (science_train* sciencetrain)
{
  trains.push_back (sciencetrain);
}


void science_train_list :: Empty ()
{
  science_train* sciencetrain;

  while (! trains.empty ()) {
    sciencetrain = trains.front ();
    delete sciencetrain;
    trains.pop_front ();
  }
}


science_train* science_train_list :: GetNext ()
{
  science_train* nexttrain = NULL;

  deque <science_train*> :: const_iterator iter = trains.begin () + next;
  if (iter != trains.end ()) {
    nexttrain = (*iter);
    next++;
  }

  return nexttrain;
}


bool science_train_list :: GetNext (science_train** sciencetrain)
{
  bool isfound = false;

  deque <science_train*> :: const_iterator iter = trains.begin () + next;
  if (iter != trains.end ()) {
    *sciencetrain = (science_train*) (*iter);
    isfound = true;
    next++;
  }

  return isfound;
}


void science_train_list :: ResetNext ()
{
  next = 0;
}
