/********** ScienceTrainLMCData.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceCalibrationLMCRecord.h"
#include "ScienceTrainLMCData.h"

science_train_lmc_data :: science_train_lmc_data ()
                        : science_train_data ()
{
  ;
}


science_train_lmc_data :: ~science_train_lmc_data ()
{
  ;
}


void science_train_lmc_data :: BuildShadowedInfo ()
{
  // reset the info
  ResetShadowedInfo ();

  // loop over the records
  science_calibration_record* record = new science_calibration_lmc_record ();
  for (int i = 0; i < GetCount (); i++) {

    // read the record
    if (Read (i, record))

      // if in shadow, add index to info
      if (record->IsInShadow ())
        AddShadowedIndex (i);
  }

  // delete the memory
  delete record;

  // set the have info flag
  haveshadowedinfo = true;
}


bool science_train_lmc_data :: Define (int train, string const& grouptype, int32 maingroupid, int32 fileid)
{
  bool isdefined = false;

  // do preliminary definition work
  if (PreDefine (train, grouptype, maingroupid, fileid)) {
 
    // set the field information
    int32 const orders [FIELDCOUNT] = {1, 1, 1, 1, 1, 1, (SCIENCE_PIXELS * LMC_SIGNAL_TERMS), 
                                 (SCIENCE_PIXELS * LMC_SIGNAL_TERMS), (SCIENCE_PIXELS * SECTOR_SIGNAL_TERMS),
				 (SCIENCE_PIXELS * SECTOR_SIGNAL_TERMS ),
                                 (SCIENCE_PACKETPOSITION * SCIENCE_PIXELS * PMC_SIGNAL_STATES),
                                 (SCIENCE_PIXELS * WARMCAL_STDDEV_TERMS * SCIENCE_PACKETPOSITION) };
    if (vdata.Define (FIELDCOUNT, DATATYPES, orders, FIELDNAMES))
      if (vdata.Set (FIELDCOUNT, FIELDNAMES))
        isdefined = true;
  }

  return isdefined;
}


bool science_train_lmc_data :: Read (int recordindex, science_calibration_record* record)
{
  bool isread = false;

  // make room for the data
  unsigned short starecount;
  int day;
  int startmsecs;
  int stopmsecs;
  unsigned short shadowflag;
  float temperature;
  float signalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float sectorsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float sectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float coldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
  float warmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION];

  // because the vdata contains fields of different types, the data must be represented as a byte array
  VOIDP bufferptrs [FIELDCOUNT];
  bufferptrs [ 0] = (VOIDP) &starecount;
  bufferptrs [ 1] = (VOIDP) &day;
  bufferptrs [ 2] = (VOIDP) &startmsecs;
  bufferptrs [ 3] = (VOIDP) &stopmsecs;
  bufferptrs [ 4] = (VOIDP) &shadowflag;
  bufferptrs [ 5] = (VOIDP) &temperature;
  bufferptrs [ 6] = (VOIDP) signalsI;
  bufferptrs [ 7] = (VOIDP) signalsII;
  bufferptrs [ 8] = (VOIDP) sectorsignalsI;
  bufferptrs [ 9] = (VOIDP) sectorsignalsII;
  bufferptrs [10] = (VOIDP) coldsignals;
  bufferptrs [11] = (VOIDP) warmsignals;

  // read the data
  if (vdata.Read (recordindex, bufferptrs)) {

    // increment the next pointer and set the read flag to OK
    next = recordindex + 1;
    isread = true;

    // stash the data in the record, first converting the signals to doubles
    double dsignalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
    double dsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
    double dsectorsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
    double dsectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
    double dwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] ;

    for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {
      for (int term = 0; term < LMC_SIGNAL_TERMS; term++) {
        dsignalsI  [pixel] [term] = (double) signalsI  [pixel] [term];
        dsignalsII [pixel] [term] = (double) signalsII [pixel] [term];
      }
      for (int secterm = 0; secterm < SECTOR_SIGNAL_TERMS; secterm++) {
        dsectorsignalsI  [pixel] [secterm] = (double) sectorsignalsI  [pixel] [secterm];
        dsectorsignalsII [pixel] [secterm] = (double) sectorsignalsII [pixel] [secterm];
      }
      for (int position = 0; position < SCIENCE_PACKETPOSITION; position++)
	for (int warmterm = 0; warmterm < WARMCAL_STDDEV_TERMS; warmterm++)  
	  dwarmsignals [pixel][warmterm][position] = (double) warmsignals [pixel][warmterm][position];
    }
    record->SetRecordData (starecount, temperature, day, startmsecs, stopmsecs, shadowflag, dsignalsI, dsignalsII, 
                           dsectorsignalsI, dsectorsignalsII );
  }
  return isread;
}


bool science_train_lmc_data :: ReadNext (science_calibration_record* record)
{
  bool isread = false;

  // make room for the data
  unsigned short starecount;
  int day;
  int startmsecs;
  int stopmsecs;
  unsigned short shadowflag;
  float temperature;
  float signalsI [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float sectorsignalsI [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float sectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float coldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
  float warmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION];

  // because the vdata contains fields of different types, the data must be represented as a byte array
  VOIDP bufferptrs [FIELDCOUNT];
  bufferptrs [ 0] = (VOIDP) &starecount;
  bufferptrs [ 1] = (VOIDP) &day;
  bufferptrs [ 2] = (VOIDP) &startmsecs;
  bufferptrs [ 3] = (VOIDP) &stopmsecs;
  bufferptrs [ 4] = (VOIDP) &shadowflag;
  bufferptrs [ 5] = (VOIDP) &temperature;
  bufferptrs [ 6] = (VOIDP) signalsI;
  bufferptrs [ 7] = (VOIDP) signalsII;
  bufferptrs [ 8] = (VOIDP) sectorsignalsI;
  bufferptrs [ 9] = (VOIDP) sectorsignalsII;
  bufferptrs [10] = (VOIDP) coldsignals;
  bufferptrs [11] = (VOIDP) warmsignals;

  // read the data
  if (vdata.Read (next, bufferptrs)) {

    // increment the next pointer and set the read flag to OK
    next++;
    isread = true;

    // stash the data in the record, first converting the signals to doubles
    double dsignalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
    double dsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
    double dsectorsignalsI [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
    double dsectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
    double dwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] ;
    for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {
      for (int term = 0; term < LMC_SIGNAL_TERMS; term++) {
        dsignalsI  [pixel] [term] = (double) signalsI  [pixel] [term];
        dsignalsII [pixel] [term] = (double) signalsII [pixel] [term];
      }
      for (int secterm = 0; secterm < SECTOR_SIGNAL_TERMS; secterm++) {
        dsectorsignalsI  [pixel] [secterm] = (double) sectorsignalsI  [pixel] [secterm];
        dsectorsignalsII [pixel] [secterm] = (double) sectorsignalsII [pixel] [secterm];
      }
      for (int position = 0; position < SCIENCE_PACKETPOSITION; position++)
	for (int warmterm = 0; warmterm < WARMCAL_STDDEV_TERMS; warmterm++) 
	  dwarmsignals [pixel][warmterm][position] = (double) warmsignals [pixel][warmterm][position];
    }
    record->SetRecordData (starecount, temperature, day, startmsecs, stopmsecs, shadowflag, dsignalsI, dsignalsII, 
                           dsectorsignalsI, dsectorsignalsII);
  }
  return isread;
}


bool science_train_lmc_data :: Write (science_calibration_record* record)
{
  bool iswritten = false;

  // grab the data out of the record
  unsigned short starecount;
  int day;
  int startmsecs;
  int stopmsecs;
  unsigned short shadowflag;
  float temperature;
  double dsignalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  double dsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  double dsectorsignalsI   [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  double dsectorsignalsII  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  double dcoldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
  double dwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] ;
  record->GetRecordData (starecount, temperature, day, startmsecs, stopmsecs, shadowflag, dsignalsI, dsignalsII, 
                         dsectorsignalsI, dsectorsignalsII, dcoldsignals, dwarmsignals);

  // convert the signals to 32-bit precision
  float signalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
  float sectorsignalsI   [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float sectorsignalsII  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
  float coldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
  float warmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION];
  for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {
    for (int term = 0; term < LMC_SIGNAL_TERMS; term++) {
      signalsI  [pixel] [term] = (float) dsignalsI  [pixel] [term];
      signalsII [pixel] [term] = (float) dsignalsII [pixel] [term];
    }
    for (int secterm = 0; secterm < SECTOR_SIGNAL_TERMS; secterm++) {
      sectorsignalsI  [pixel] [secterm] = (float) dsectorsignalsI  [pixel] [secterm];
      sectorsignalsII [pixel] [secterm] = (float) dsectorsignalsII [pixel] [secterm];
    }
    for ( int pos = 0; pos < SCIENCE_PACKETPOSITION; pos++ )
      for ( int state = 0; state < PMC_SIGNAL_STATES; state++ )
	coldsignals [pos] [pixel] [state] = (float) dcoldsignals [pos] [pixel] [state];
    for (int position = 0; position < SCIENCE_PACKETPOSITION; position++)
      for (int warmterm = 0; warmterm < WARMCAL_STDDEV_TERMS; warmterm++) 
	warmsignals  [pixel][warmterm][position] = (float) dwarmsignals  [pixel][warmterm][position];
  }

  // because the vdata contains fields of different types, the data must be represented as a byte array
  VOIDP bufferptrs [FIELDCOUNT];
  bufferptrs [ 0] = (VOIDP) &starecount;
  bufferptrs [ 1] = (VOIDP) &day;
  bufferptrs [ 2] = (VOIDP) &startmsecs;
  bufferptrs [ 3] = (VOIDP) &stopmsecs;
  bufferptrs [ 4] = (VOIDP) &shadowflag;
  bufferptrs [ 5] = (VOIDP) &temperature;
  bufferptrs [ 6] = (VOIDP) signalsI;
  bufferptrs [ 7] = (VOIDP) signalsII;
  bufferptrs [ 8] = (VOIDP) sectorsignalsI;
  bufferptrs [ 9] = (VOIDP) sectorsignalsII;
  bufferptrs [10] = (VOIDP) coldsignals;
  bufferptrs [11] = (VOIDP) warmsignals;

  // write the data
  if (vdata.Write (bufferptrs))
    iswritten = true;

  return iswritten;
}
