/********** ScienceTrainGroup.h ***************************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_TRAIN_GROUP_

  #define _MOPITT_L1_SCIENCE_TRAIN_GROUP_

  #include "HDFVGroup.h"
  #include "ScienceTrainData.h"
  #include "ScienceCalibrationRecord.h"

  class science_train_group {
    private :
      int        train;
      int32      parentid;
      int32      fileid;
      hdf_vgroup vgroup;

      bool IsInitialized () const {return (train > 0 && parentid > 0 && fileid > 0 && colddata != NULL && 
                                           warmdata != NULL && hotdata != NULL && tepiddata != NULL);}

    protected :
      science_train_data* colddata;
      science_train_data* warmdata;
      science_train_data* hotdata;
      science_train_data* tepiddata;

    public :
      science_train_group ();
      science_train_group (int);
      science_train_group (int, int32, int32);
      virtual ~science_train_group () = 0;

      bool AddRecord                (enum science_train_data_type, science_calibration_record*);
      bool Attach                   ();
      bool Close                    ();
      bool Define                   ();
      bool GetClosestRecord         (mopitt_time const&, enum science_train_data_type, science_calibration_record*);
      bool GetClosestShadowedRecord (mopitt_time const&, enum science_train_data_type, science_calibration_record*);
      int  GetEventCount            (enum science_train_data_type) const;
      bool GetNextRecord            (enum science_train_data_type, science_calibration_record*);
      bool GetRecord                (int, enum science_train_data_type, science_calibration_record*);
      int  GetShadowedEventCount    (enum science_train_data_type) const;
      bool GetShadowedRecord        (int, enum science_train_data_type, science_calibration_record*);
      void SetIDs                   (int32, int32);
  };

#endif
