/********** ScienceTrainGroup.C ***************************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrainGroup.h"

science_train_group :: science_train_group ()
                     : vgroup ()
{
  train = 0;
  parentid = 0;
  fileid = 0;
  colddata = NULL;
  warmdata = NULL;
  hotdata = NULL;
  tepiddata = NULL;
}


science_train_group :: science_train_group (int trainnumber)
                     : vgroup ()
{
  train = trainnumber;
  parentid = 0;
  fileid = 0;
  colddata = NULL;
  warmdata = NULL;
  hotdata = NULL;
  tepiddata = NULL;
}


science_train_group :: science_train_group (int trainnumber, int32 parent, int32 file)
                     : vgroup ()
{
  train = trainnumber;
  parentid = parent;
  fileid = file;
  colddata = NULL;
  warmdata = NULL;
  hotdata = NULL;
  tepiddata = NULL;
}


science_train_group :: ~science_train_group ()
{
  ;
}


bool science_train_group :: AddRecord (enum science_train_data_type datatype, science_calibration_record* record)
{
  bool isadded = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isadded = colddata->Write (record); 
                             break;
      case WARM_DATA_TYPE  : isadded = warmdata->Write (record); 
                             break;
      case HOT_DATA_TYPE   : isadded = hotdata->Write (record); 
                             break;
      case TEPID_DATA_TYPE : isadded = tepiddata->Write (record); 
                             break;
    }

  return isadded;
}


bool science_train_group :: Attach ()
{
  bool isattached = false;

  if (IsInitialized ()) {
    char groupname [40];
    (void) sprintf (groupname, "Science Train %1d Group", train);
    if (vgroup.Attach (fileid, groupname))
      if (colddata->Attach (train, "Cold", fileid))
        if (warmdata->Attach (train, "Warm", fileid))
          if (hotdata->Attach (train, "Hot", fileid))
            if (tepiddata->Attach (train, "Tepid", fileid))
              isattached = true;
  }

  return isattached;
}


bool science_train_group :: Close ()
{
  bool isclosed = false;

  if (IsInitialized ())
    if (colddata->Close ())
      if (warmdata->Close ())
        if (hotdata->Close ())
          if (tepiddata->Close ())
            if (vgroup.Close ())
              isclosed = true;

  return isclosed;
}


bool science_train_group :: Define ()
{
  bool isdefined = false;

  if (IsInitialized ()) {
    char groupname [40];
    (void) sprintf (groupname, "Science Train %1d Group", train);
    if (vgroup.Create (groupname, "Science Data Group", fileid))
      if (colddata->Define (train, "Cold", vgroup.GetID (), fileid))
        if (warmdata->Define (train, "Warm", vgroup.GetID (), fileid))
          if (hotdata->Define (train, "Hot", vgroup.GetID (), fileid))
            if (tepiddata->Define (train, "Tepid", vgroup.GetID (), fileid))
              if (vgroup.Insert (parentid))
                isdefined = true;
  }

  return isdefined;
}


bool science_train_group :: GetClosestRecord (mopitt_time const& searchtime, enum science_train_data_type datatype, 
                                              science_calibration_record* record)
{
  bool isretrieved = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isretrieved = colddata->ReadClosest  (searchtime, record);
                             break;
      case WARM_DATA_TYPE  : isretrieved = warmdata->ReadClosest  (searchtime, record);
                             break;
      case HOT_DATA_TYPE   : isretrieved = hotdata->ReadClosest   (searchtime, record);
                             break;
      case TEPID_DATA_TYPE : isretrieved = tepiddata->ReadClosest (searchtime, record);
                             break;
    }

  return isretrieved;
}


bool science_train_group :: GetClosestShadowedRecord (mopitt_time const& searchtime, 
                                                      enum science_train_data_type datatype, 
                                                      science_calibration_record* record)
{
  bool isretrieved = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isretrieved = colddata->ReadClosestShadowed  (searchtime, record);
                             break;
      case WARM_DATA_TYPE  : isretrieved = warmdata->ReadClosestShadowed  (searchtime, record);
                             break;
      case HOT_DATA_TYPE   : isretrieved = hotdata->ReadClosestShadowed   (searchtime, record);
                             break;
      case TEPID_DATA_TYPE : isretrieved = tepiddata->ReadClosestShadowed (searchtime, record);
                             break;
    }

  return isretrieved;
}


int science_train_group :: GetEventCount (enum science_train_data_type datatype) const
{
  int eventcount = 0;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : eventcount = colddata->GetCount ();
                             break;
      case WARM_DATA_TYPE  : eventcount = warmdata->GetCount ();
                             break;
      case HOT_DATA_TYPE   : eventcount = hotdata->GetCount ();
                             break;
      case TEPID_DATA_TYPE : eventcount = tepiddata->GetCount ();
                             break;
    }

  return eventcount;
}


bool science_train_group :: GetNextRecord (enum science_train_data_type datatype, science_calibration_record* record)
{
  bool isretrieved = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isretrieved = colddata->ReadNext  (record);
                             break;
      case WARM_DATA_TYPE  : isretrieved = warmdata->ReadNext  (record);
                             break;
      case HOT_DATA_TYPE   : isretrieved = hotdata->ReadNext   (record);
                             break;
      case TEPID_DATA_TYPE : isretrieved = tepiddata->ReadNext (record);
                             break;
    }

  return isretrieved;
}


bool science_train_group :: GetRecord (int recordindex, enum science_train_data_type datatype, 
                                       science_calibration_record* record)
{
  bool isretrieved = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isretrieved = colddata->Read  (recordindex, record);
                             break;
      case WARM_DATA_TYPE  : isretrieved = warmdata->Read  (recordindex, record);
                             break;
      case HOT_DATA_TYPE   : isretrieved = hotdata->Read   (recordindex, record);
                             break;
      case TEPID_DATA_TYPE : isretrieved = tepiddata->Read (recordindex, record);
                             break;
    }

  return isretrieved;
}


int science_train_group :: GetShadowedEventCount (enum science_train_data_type datatype) const
{
  int eventcount = 0;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : eventcount = colddata->GetShadowedCount ();
                             break;
      case WARM_DATA_TYPE  : eventcount = warmdata->GetShadowedCount ();
                             break;
      case HOT_DATA_TYPE   : eventcount = hotdata->GetShadowedCount ();
                             break;
      case TEPID_DATA_TYPE : eventcount = tepiddata->GetShadowedCount ();
                             break;
    }

  return eventcount;
}


bool science_train_group :: GetShadowedRecord (int recordindex, enum science_train_data_type datatype, 
                                               science_calibration_record* record)
{
  bool isretrieved = false;

  if (IsInitialized ())
    switch (datatype) {
      case COLD_DATA_TYPE  : isretrieved = colddata->ReadShadowed  (recordindex, record);
                             break;
      case WARM_DATA_TYPE  : isretrieved = warmdata->ReadShadowed  (recordindex, record);
                             break;
      case HOT_DATA_TYPE   : isretrieved = hotdata->ReadShadowed   (recordindex, record);
                             break;
      case TEPID_DATA_TYPE : isretrieved = tepiddata->ReadShadowed (recordindex, record);
                             break;
    }

  return isretrieved;
}


void science_train_group :: SetIDs (int32 parent, int32 file)
{
  parentid = parent;
  fileid = file;
}
