/********** ScienceTrainData.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_TRAIN_DATA_

  #define _MOPITT_L1_SCIENCE_TRAIN_DATA_

  #include "HDFVGroup.h"
  #include "HDFVData.h"
  #include "ScienceCalibrationRecord.h"
  #include "ScienceConstants.h"

  int const FIELDCOUNT = 12;

  class science_train_data {
    private :

    protected :
      static string const FIELDNAMES [FIELDCOUNT];
      static int32 const DATATYPES  [FIELDCOUNT];

      int        next;
      hdf_vgroup vgroup;
      hdf_vdata  vdata;
      bool       haveshadowedinfo;
      int        shadowedcount;
      int*       shadowedindeces;

      bool   PreDefine         (int, string const&, int32, int32);
      double AbsoluteTimeDiff  (mopitt_time const& time1, mopitt_time const& time2) const 
                                {return ((time1 > time2) ? time1.GetTAI () - time2.GetTAI () :
                                         time2.GetTAI () - time1.GetTAI ());}
      void   AddShadowedIndex  (int);
      void   ResetShadowedInfo ();

      virtual void BuildShadowedInfo () {;}

    public :
      science_train_data ();
      virtual ~science_train_data () = 0;

      bool         Attach              (int, string const&, int32);
      bool         Close               ();
      virtual bool Define              (int, string const&, int32, int32) {return false;}
      int          GetCount            () const {return vdata.GetCount ();}
      int          GetShadowedCount    ();
      virtual bool Read                (int, science_calibration_record*) {return false;}
      virtual bool ReadClosest         (mopitt_time const&, science_calibration_record*);
      virtual bool ReadClosestShadowed (mopitt_time const&, science_calibration_record*);
      virtual bool ReadNext            (science_calibration_record*) {return false;}
      bool         ReadShadowed        (int, science_calibration_record*); 
      void         ResetNext           ();
      virtual bool Write               (science_calibration_record*) {return false;}
  };

#endif
