/********** ScienceTrain4.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   03/01   Ziskin
   09/01   Debbie Mao
   10/01   Debbie Mao
   02/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrain4.h"

int const           science_train_4::SATURATION_COUNT               = 15335190;
int const           science_train_4::MINIMUM_VALID_COUNT_I          = 3600000;
int const           science_train_4::MINIMUM_VALID_COUNT_II         = 2300000;
int const           science_train_4::MIRROR_POSITION_START          = 18;
int const           science_train_4::MIRROR_STATUS_START            = 22;
int const           science_train_4::DATA_START                     = 1068;
unsigned char const science_train_4::ACTIVE_MASK_I                  = 0x40;
unsigned char const science_train_4::ACTIVE_MASK_II                 = 0x80;
int const           science_train_4::PIXEL_MAPS_I [SCIENCE_PIXELS]  = {0, 3, 2, 1};
int const           science_train_4::PIXEL_MAPS_II [SCIENCE_PIXELS] = {1, 2, 3, 0};

science_train_4 :: science_train_4 ()
                 : science_train (4)
                 , channelI (7, MINIMUM_VALID_COUNT_I, SATURATION_COUNT)
                 , channelII (8, MINIMUM_VALID_COUNT_II, SATURATION_COUNT)
{
  ;
}


science_train_4 :: science_train_4 (mopitt_time const& traintime, unsigned char bitmask, unsigned char* staredata,
                                    table_collection& tablecollection, processor_parameters const& processorparameters,
                                    int packetposition)
                 : science_train (4, traintime, staredata[MIRROR_STATUS_START], &staredata[MIRROR_POSITION_START], 
                                  packetposition)
                 , channelI (7, MINIMUM_VALID_COUNT_I, SATURATION_COUNT)
                 , channelII (8, MINIMUM_VALID_COUNT_II, SATURATION_COUNT)
{
  // get the table data for this train
  short chopperopensamples, chopperclosedsamples, lmcscalefactor, pmcscalefactor, lmcchoppercycles, pmcchoppercycles;
  tablecollection.GetData (4, traintime, chopperopensamples, chopperclosedsamples, lmcscalefactor, pmcscalefactor, 
                           lmcchoppercycles, pmcchoppercycles);

  // read the channels
  channelI.Read  ((bitmask & ACTIVE_MASK_I  ? true : false), PIXEL_MAPS_I,  &staredata[DATA_START], chopperopensamples,
                  chopperclosedsamples, pmcscalefactor, pmcchoppercycles, processorparameters, traintime);
  channelII.Read ((bitmask & ACTIVE_MASK_II ? true : false), PIXEL_MAPS_II, &staredata[DATA_START + PMC_CHANNEL_SIZE],
                  chopperopensamples, chopperclosedsamples, lmcscalefactor, lmcchoppercycles,processorparameters);
}


science_train_4 :: ~science_train_4 ()
{
  ;
}


void science_train_4 :: GetLastcellState (enum science_channel_number channelnumber, int &lastcell ) 
{
  if (channelnumber == CHANNEL_II)
    channelII.GetLastcellState( lastcell );
}


void science_train_4 :: GetSignal (enum science_channel_number channelnumber, double* signalterms, 
                                   bool isvalid [SCIENCE_PIXELS]) const
{
  if (channelnumber == CHANNEL_I) {
    double newsignals [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS];
    channelI.GetSignal (newsignals, isvalid);
    (void) memcpy ((void*) signalterms, (const void*) newsignals, sizeof (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS]));
  }
  else {
    double newsignals [SCIENCE_PIXELS] [LMC_SAWTOOTH_SET];
    channelII.GetSignal (newsignals, isvalid);
    (void) memcpy ((void*) signalterms, (const void*) newsignals, sizeof (double [SCIENCE_PIXELS] [LMC_SAWTOOTH_SET]));
  }
}


void science_train_4 :: GetMeans (enum science_channel_number channelnumber, double* openmeans, double* closedmeans,
                                  bool isvalid [SCIENCE_PIXELS]) const
{
  if (channelnumber == CHANNEL_I) {
    double newopenmeans [SCIENCE_PIXELS] [PMC_STROKES], newclosedmeans [SCIENCE_PIXELS] [PMC_STROKES];
    channelI.GetMeans  (newopenmeans, newclosedmeans, isvalid);
    (void) memcpy ((void*) openmeans,   (const void*) newopenmeans,   sizeof (double [SCIENCE_PIXELS] [PMC_STROKES]));
    (void) memcpy ((void*) closedmeans, (const void*) newclosedmeans, sizeof (double [SCIENCE_PIXELS] [PMC_STROKES]));
  }
  else {
    double newopenmeans [SCIENCE_PIXELS] [LMC_SECTORS], newclosedmeans [SCIENCE_PIXELS] [LMC_SECTORS];
    channelII.GetMeans (newopenmeans, newclosedmeans, isvalid);
    (void) memcpy ((void*) openmeans,   (const void*) newopenmeans,   sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
    (void) memcpy ((void*) closedmeans, (const void*) newclosedmeans, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
  }
}


double science_train_4 :: GetClosedCount (enum science_channel_number channelnumber, int pixelindex, 
                                          int stateindex) const
{
  if (channelnumber == CHANNEL_I)
    return channelI.GetClosedCount (pixelindex, stateindex);
  else
    return channelII.GetClosedCount (pixelindex, stateindex);
}


double science_train_4 :: GetOpenCount (int pixelindex, int stateindex) const
{
    return channelI.GetOpenCount (pixelindex, stateindex);
}


double science_train_4 :: GetOpenCount (enum science_channel_number channelnumber, int pixelindex, int stateindex, 
                                        int rotationindex) const
{
    return channelII.GetOpenCount (pixelindex, stateindex, rotationindex);
}
