/********** ScienceTrain3.h *******************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   03/01   Ziskin
   09/01   Debbie Mao
   10/01   Debbie Mao
   02/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_TRAIN_3_

  #define _MOPITT_L1_SCIENCE_TRAIN_3_

  #include "TableCollection.h"
  #include "ProcessorParameters.h"
  #include "ScienceTrain.h"
  #include "ScienceLMCFoldoverChannel.h"

  class science_train_3 : public science_train {
    private :
      static int const           MAXIMUM_FOLDOVER_COUNT;
      static int const           MINIMUM_VALID_COUNT_I;
      static int const           MINIMUM_VALID_COUNT_II;
      static int const           MIRROR_POSITION_START;
      static int const           MIRROR_STATUS_START;
      static int const           DATA_START;
      static unsigned char const ACTIVE_MASK_I;
      static unsigned char const ACTIVE_MASK_II;
      static int const           PIXEL_MAPS_I [SCIENCE_PIXELS];
      static int const           PIXEL_MAPS_II [SCIENCE_PIXELS];

      science_lmc_foldover_channel channelI;
      science_lmc_foldover_channel channelII;

    protected :

    public :
      science_train_3 ();
      science_train_3 (mopitt_time const&, unsigned char, unsigned char*, table_collection&, processor_parameters const&, int);
      ~science_train_3 ();

      void   GetSignal        (enum science_channel_number, double*, bool [SCIENCE_PIXELS]) const;
      void   GetMeans         (enum science_channel_number, double*, double*, bool [SCIENCE_PIXELS]) const;
      double GetClosedCount   (enum science_channel_number, int, int) const;
      double GetOpenCount     (enum science_channel_number, int, int, int) const;
      void   GetLastcellState (enum science_channel_number, int&) ;
  };

#endif
