/********** ScienceTrain3.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   03/01   Ziskin
   09/01   Debbie Mao
   10/01   Debbie Mao
   02/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceTrain3.h"

int const           science_train_3::MAXIMUM_FOLDOVER_COUNT         = 392954;
int const           science_train_3::MINIMUM_VALID_COUNT_I          = 5500000;
int const           science_train_3::MINIMUM_VALID_COUNT_II         = 2500000;
int const           science_train_3::MIRROR_POSITION_START          = 16;
int const           science_train_3::MIRROR_STATUS_START            = 23;
int const           science_train_3::DATA_START                     = 672;
unsigned char const science_train_3::ACTIVE_MASK_I                  = 0x10;
unsigned char const science_train_3::ACTIVE_MASK_II                 = 0x20;
int const           science_train_3::PIXEL_MAPS_I [SCIENCE_PIXELS]  = {1, 2, 3, 0};
int const           science_train_3::PIXEL_MAPS_II [SCIENCE_PIXELS] = {0, 3, 2, 1};

science_train_3 :: science_train_3 ()
                 : science_train (3)
                 , channelI (5, MINIMUM_VALID_COUNT_I, MAXIMUM_FOLDOVER_COUNT)
                 , channelII (6, MINIMUM_VALID_COUNT_II, MAXIMUM_FOLDOVER_COUNT)
{
  ;
}


science_train_3 :: science_train_3 (mopitt_time const& traintime, unsigned char bitmask, unsigned char* staredata,
                                    table_collection& tablecollection, processor_parameters const& processorparameters, 
                                    int packetposition)
                 : science_train (3, traintime, staredata[MIRROR_STATUS_START], &staredata[MIRROR_POSITION_START], 
                                  packetposition)
                 , channelI (5, MINIMUM_VALID_COUNT_I, MAXIMUM_FOLDOVER_COUNT)
                 , channelII (6, MINIMUM_VALID_COUNT_II, MAXIMUM_FOLDOVER_COUNT)
{
  // get the table data for this train
  short chopperopensamples, chopperclosedsamples, scalefactor, choppercycles;
  tablecollection.GetData (3, traintime, chopperopensamples, chopperclosedsamples, scalefactor, choppercycles);

  // read the channels
  channelI.Read  ((bitmask & ACTIVE_MASK_I  ? true : false), PIXEL_MAPS_I,  &staredata[DATA_START], chopperopensamples,
                  chopperclosedsamples, scalefactor, choppercycles,processorparameters);
  channelII.Read ((bitmask & ACTIVE_MASK_II ? true : false), PIXEL_MAPS_II, &staredata[DATA_START + LMC_CHANNEL_SIZE],
                  chopperopensamples, chopperclosedsamples, scalefactor, choppercycles,processorparameters);


}


science_train_3 :: ~science_train_3 ()
{
  ;
}


void science_train_3 :: GetLastcellState (enum science_channel_number channelnumber, int &lastcell)
{
  if (channelnumber == CHANNEL_I) 
    channelI.GetLastcellState(lastcell);
  else
    channelII.GetLastcellState(lastcell);
}


void science_train_3 :: GetSignal (enum science_channel_number channelnumber, double* signalterms, 
                                       bool isvalid [SCIENCE_PIXELS]) const
{
  double newsignals [SCIENCE_PIXELS] [LMC_SAWTOOTH_SET];

  if (channelnumber == CHANNEL_I) 
    channelI.GetSignal (newsignals, isvalid);
  else
    channelII.GetSignal (newsignals, isvalid);

  (void) memcpy ((void*) signalterms, (const void*) newsignals, sizeof (double [SCIENCE_PIXELS] [LMC_SAWTOOTH_SET]));
}


void science_train_3 :: GetMeans (enum science_channel_number channelnumber, double* openmeans, double* closedmeans,
                                  bool isvalid [SCIENCE_PIXELS]) const
{
  double newopenmeans [SCIENCE_PIXELS] [LMC_SECTORS], newclosedmeans [SCIENCE_PIXELS] [LMC_SECTORS];

  if (channelnumber == CHANNEL_I)
    channelI.GetMeans  (newopenmeans, newclosedmeans, isvalid);
  else
    channelII.GetMeans (newopenmeans, newclosedmeans, isvalid);

  (void) memcpy ((void*) openmeans,   (const void*) newopenmeans,   sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
  (void) memcpy ((void*) closedmeans, (const void*) newclosedmeans, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
}


double science_train_3 :: GetClosedCount (enum science_channel_number channelnumber, int pixelindex, 
                                          int stateindex) const
{
  if (channelnumber == CHANNEL_I)
    return channelI.GetClosedCount (pixelindex, stateindex);
  else
    return channelII.GetClosedCount (pixelindex, stateindex);
}


double science_train_3 :: GetOpenCount (enum science_channel_number channelnumber, int pixelindex, int stateindex, 
                                        int rotationindex) const
{
  if (channelnumber == CHANNEL_I)
    return channelI.GetOpenCount (pixelindex, stateindex, rotationindex);
  else
    return channelII.GetOpenCount (pixelindex, stateindex, rotationindex);
}
