/********** ScienceTrain.h ********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   05/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_TRAIN_

  #define _MOPITT_L1_SCIENCE_TRAIN_

  #include "MOPITTTime.h"
  #include "ScienceConstants.h"
  #include "ScienceChannel.h"

  int const STARE_MSECS_GAP_EPSILON              = 50;
  int const TRAIN_CHANNELS                       = 2;
  int const SPACE_CALIBRATION_MIRROR_POSITION    = -50;
  int const INTERNAL_CALIBRATION_MIRROR_POSITION = -100;

  class science_train {
    private :
      static int const MIRROR_WARNING;
      static int const EARTHVIEW_MIRROR_POSITION_RANGE [2];
      static int const EARTHVIEW_MIRROR_POSITIONS [SCIENCE_STARES];

    protected :
      int           train;
      mopitt_time   time;
      int           mirrorposition;
      unsigned char mirrorstatus;
      int           packetposition;

    public :
      science_train ();
      science_train (int);
      science_train (int, mopitt_time const&, unsigned char, unsigned char*, int);
      virtual ~science_train () = 0;

      virtual void            GetSignal         (enum science_channel_number, double*, bool [SCIENCE_PIXELS]) const = 0;
      virtual double          GetClosedCount    (enum science_channel_number, int, int) const {return 0;}
      virtual void            GetMeans          (enum science_channel_number, double*, double*, 
                                                 bool [SCIENCE_PIXELS]) const = 0;
      virtual double          GetOpenCount      (enum science_channel_number, int, int, int) const {return 0;}
      virtual double          GetOpenCount      (int, int) const { return 0;}
      int                     GetID             () const {return train;}
      int                     GetMirrorPosition () const {return mirrorposition;}
      int                     GetMsecs          () const {return time.GetMsecs ();}
      int                     GetStareNumber    () const;
      mopitt_time const&      GetTime           () const {return time;}
      enum science_train_type GetType           () const;
      int                     GetPacketPosition () {return packetposition;}
      virtual void            GetLastcellState  (enum science_channel_number, int&) { ; };

  };

#endif

