/********** ScienceTrain.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <memory.h>
#include "ScienceTrain.h"
#include "DiagnosticReporter.h"

int const science_train::MIRROR_WARNING                              = 801;
int const science_train::EARTHVIEW_MIRROR_POSITION_RANGE [2]         = {-14, 14};
int const science_train::EARTHVIEW_MIRROR_POSITIONS [SCIENCE_STARES] = {-14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 
                                                                         10, 12, 14, 13, 11, 9, 7, 5, 3, 1, -1, -3, -5,
                                                                         -7, -9, -11, -13};

extern diagnostic_reporter diagnosticreporter;

science_train :: science_train ()
               : time ()
{
  train = 0;
  mirrorposition = 0;
  mirrorstatus = 0;
}


science_train :: science_train (int trainnumber)
               : time ()
{
  train = trainnumber;
  mirrorposition = 0;
  mirrorstatus = 0;
}


science_train :: science_train (int trainnumber, mopitt_time const& staretime, unsigned char mirrorstat, 
                                unsigned char* mirrorpos, int packetpos)
               : time (staretime)
{
  train = trainnumber;
  mirrorposition = (int) ((short) ((mirrorpos[0] * 256) + mirrorpos[1]));
  mirrorstatus = mirrorstat;
  packetposition = packetpos;
}


science_train :: ~science_train ()
{
  ;
}


int science_train :: GetStareNumber () const
{
  int stareindex = 0;
  for (; stareindex < SCIENCE_STARES && EARTHVIEW_MIRROR_POSITIONS [stareindex] != mirrorposition; stareindex++);

  return stareindex + 1;
}


enum science_train_type science_train :: GetType () const
{
  if (mirrorposition >= EARTHVIEW_MIRROR_POSITION_RANGE[0] && 
      mirrorposition <= EARTHVIEW_MIRROR_POSITION_RANGE[1])
    return EARTHVIEW_TRAIN;
  else if (mirrorposition == SPACE_CALIBRATION_MIRROR_POSITION || 
           mirrorposition == INTERNAL_CALIBRATION_MIRROR_POSITION)
    return CALIBRATION_TRAIN;
  else {
    char mirrorchars [10];
    (void) sprintf (mirrorchars, "%d", mirrorposition);
    string message = "Invalid mirror position ";
    message += mirrorchars;
    diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_SCIENCE_MODULE, MIRROR_WARNING, 0, 0, 0, 0, train, 0,
                                 0, 0, message);
    return ERRONEOUS_TRAIN;
  }
}
