/********** ScienceStare.h ********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   05/00   Daniel Ziskin
   05/00   Charles Cavanaugh
   03/01   Ziskin
   09/01   Debbie

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_STARE_

  #define _MOPITT_L1_SCIENCE_STARE_

  #include "TableCollection.h"
  #include "ProcessorParameters.h"
  #include "ScienceTrain.h"

  int const SCIENCE_STARE_SIZE = 1320;

  class science_stare {
    private :
      static int const STARE_ID_START;
      static int const STARE_BITMASK_START;
      static int const STARE_TIME_START;
      static int const TRAIN_WARNING;

      unsigned char* data;
      unsigned char  id;
      unsigned char  bitmask;
      mopitt_time    time;
      int            trainnumber;

      void Set (mopitt_time const&, unsigned char*);

    protected :

    public :
      science_stare ();
      science_stare (mopitt_time const&, unsigned char*);
      ~science_stare ();

      unsigned char      GetID          () const {return id;}
      science_train*     GetNextTrain   (table_collection&, processor_parameters const&);
      int                GetPacketPosition () const {return ((id - 'S') + 1);}
      mopitt_time const& GetTime        () const {return time;}
      bool               HasCorrectID   () const {return (id == 'S' || id == 'T' || id == 'U' || id == 'V' || 
                                                          id == 'W');}
      bool               HasMoreTrains  () const {return (trainnumber <= SCIENCE_TRAINS);}
  };

#endif
