/********** ScienceStare.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   05/00   Daniel Ziskin
   05/00   Charles Cavanaugh
   03/01   Ziskin
   09/01   Debbie

 $Log$

\**********************************************************************************************************************/

#include <memory.h>
#include "ScienceStare.h"
#include "ScienceTrain1.h"
#include "ScienceTrain2.h"
#include "ScienceTrain3.h"
#include "ScienceTrain4.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const science_stare::STARE_ID_START      = 0;
int const science_stare::STARE_BITMASK_START = 1;
int const science_stare::STARE_TIME_START    = 4;
int const science_stare::TRAIN_WARNING       = 806;

science_stare :: science_stare ()
               : time ()
{
  id = 0;
  bitmask = 0;
  data = NULL;
  trainnumber = 1;
}


science_stare :: science_stare (mopitt_time const& packettime, unsigned char* packetdata)
{
  Set (packettime, packetdata);
}


science_stare :: ~science_stare ()
{
  delete [] data;
}


void science_stare :: Set (mopitt_time const& packettime, unsigned char* packetdata)
{
  // set the train number to the first train
  trainnumber = 1;

  // make room for the data and copy it
  data = new unsigned char [SCIENCE_STARE_SIZE];
  (void) memcpy ((void*) data, (const void*) packetdata, SCIENCE_STARE_SIZE);

  // get the id
  id = data[STARE_ID_START];

  // get the bitmask;
  bitmask = data[STARE_BITMASK_START];

  // get the stare time and fix rollover if necessary
  int staremsecs = (data[STARE_TIME_START + 2] * 16777216) + (data[STARE_TIME_START + 3] * 65536) + 
                   (data[STARE_TIME_START + 0] * 256)      + (int) data[STARE_TIME_START + 1];
  if (staremsecs > 86400000)
    staremsecs -= 86400000;

  if ((staremsecs < 86400001 ) && (staremsecs > -1)) {
    int stareday = packettime.GetDay ();
    if (staremsecs > packettime.GetMsecs ())
      stareday--;

    time.Set (stareday, staremsecs);
  }
  else {
    // Set the id to M - which is different than S, T, U, V, W
    id = 'M';
  }
}


science_train* science_stare :: GetNextTrain (table_collection& tablecollection, processor_parameters const& processorparameters)
{
  science_train* sciencetrain = NULL;

  // the type of train object to return depends on the train number
  switch (trainnumber) {
    case 1 : sciencetrain = new science_train_1 (time, bitmask, data, tablecollection, processorparameters, GetPacketPosition());
             break;
    case 2 : sciencetrain = new science_train_2 (time, bitmask, data, tablecollection, processorparameters, GetPacketPosition());
             break;
    case 3 : sciencetrain = new science_train_3 (time, bitmask, data, tablecollection, processorparameters, GetPacketPosition());
             break;
    case 4 : sciencetrain = new science_train_4 (time, bitmask, data, tablecollection, processorparameters, GetPacketPosition());
             break;
    default : diagnosticreporter.AddEntry (DIAGNOSTICS_WARNING, DIAGNOSTICS_SCIENCE_MODULE, TRAIN_WARNING, 0, 0, 0, 0,
                                           trainnumber, 0, 0, 0, "Incorrect train number for stare train retrieval");
  }

  // increment the train number
  trainnumber++;

  return sciencetrain;
}
