/********** ScienceSpaceSectorMeans.C *********************************************************************************\

 $Header$

 REVISION HISTORY
   12/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <memory.h>
#include "ScienceSpaceSectorMeans.h"

science_space_sector_means :: science_space_sector_means ()
{
  isset = false;
}


science_space_sector_means :: ~science_space_sector_means ()
{
  ;
}


bool science_space_sector_means :: Get (double newmean [SCIENCE_PIXELS] [LMC_SECTORS], 
                                        double newnoise [SCIENCE_PIXELS] [LMC_SECTORS]) const
{ 
  if (isset) {
    (void) memcpy ((void*) newmean,  (const void*) means, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
    (void) memcpy ((void*) newnoise, (const void*) noise, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
  }

  return isset;
}


bool science_space_sector_means :: Get (int pixel, double newmean [LMC_SECTORS], double newnoise [LMC_SECTORS]) const 
{
  bool isretrieved = false;
 
  if (isset && pixel >= 0 && pixel < SCIENCE_PIXELS) {
    (void) memcpy ((void*) newmean,  (const void*) means [pixel], sizeof (double [LMC_SECTORS]));
    (void) memcpy ((void*) newnoise, (const void*) noise [pixel], sizeof (double [LMC_SECTORS]));
    isretrieved = true;
  }

  return isretrieved;
}


void science_space_sector_means :: Set (double const newmeans [SCIENCE_PIXELS] [LMC_SECTORS], 
                                        double const newnoise [SCIENCE_PIXELS] [LMC_SECTORS])
{
  (void) memcpy ((void*) means, (const void*) newmeans, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
  (void) memcpy ((void*) noise, (const void*) newnoise, sizeof (double [SCIENCE_PIXELS] [LMC_SECTORS]));
  isset = true;
}
