/********** SciencePMCSignal.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "SciencePMCSignal.h"

science_pmc_signal :: science_pmc_signal ()
{
  ;
}


science_pmc_signal :: ~science_pmc_signal ()
{
  ;
}


void science_pmc_signal :: ComputeSignal (double const openmeans [PMC_STROKES], 
                                          double const openvariance [PMC_STROKES],
                                          double const closedmeans [PMC_STROKES],
                                          double const closedvariance [PMC_STROKES],
                                          double signals [PMC_SIGNAL_TERMS]) const
{
  double highsignal = openmeans [PMC_HIGH_STROKE] - closedmeans [PMC_HIGH_STROKE];
  double lowsignal  = openmeans [PMC_LOW_STROKE]  - closedmeans [PMC_LOW_STROKE];

  double highsignalvariance = openvariance [PMC_HIGH_STROKE] + closedvariance [PMC_HIGH_STROKE];
  double lowsignalvariance  = openvariance [PMC_LOW_STROKE]  + closedvariance [PMC_LOW_STROKE];

  signals [PMC_SIGNAL_AVERAGE_AVERAGE]     = (highsignal + lowsignal) / 2.0;
  signals [PMC_SIGNAL_DIFFERENCE_AVERAGE]  = highsignal - lowsignal;
  signals [PMC_SIGNAL_AVERAGE_VARIANCE]    = (highsignalvariance + lowsignalvariance) / 4.0;
  signals [PMC_SIGNAL_DIFFERENCE_VARIANCE] = highsignalvariance + lowsignalvariance;
}
