/********** SciencePMCChannel.h ***************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   01/10   Debbie Mao
   02/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_PMC_SCIENCE_CHANNEL_

  #define _MOPITT_L1_PMC_SCIENCE_CHANNEL_

  #include "ScienceChannel.h"
  #include "SciencePMCSignal.h"
  #include "ProcessorParameters.h"

  int const PMC_CHANNEL_SIZE = 54;

  class science_pmc_channel : public science_channel, public science_pmc_signal {
    private :
      static int const PMC_STROKE_SIZE;

      double opencounts   [SCIENCE_PIXELS] [PMC_STROKES];
      double closedcounts [SCIENCE_PIXELS] [PMC_STROKES];

    protected :

    public :
      science_pmc_channel ();
      science_pmc_channel (int);
      science_pmc_channel (int, int, int);
      ~science_pmc_channel ();

      double GetClosedCount (int pixelindex, int strokeindex) const {return closedcounts [pixelindex] [strokeindex];}
      double GetOpenCount   (int pixelindex, int strokeindex) const {return opencounts [pixelindex] [strokeindex];}
      void   GetSignal      (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS], bool [SCIENCE_PIXELS]) const;
      void   GetMeans       (double [SCIENCE_PIXELS] [PMC_STROKES], double [SCIENCE_PIXELS] [PMC_STROKES],
                             bool [SCIENCE_PIXELS]) const;
      void   Read           (bool, int const [SCIENCE_PIXELS],unsigned char*,short,short,short,short, 
                             processor_parameters const&,mopitt_time const& );
  };

#endif
