/********** SciencePMCChannel.C ***************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   12/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   06/00   Charles Cavanaugh
   01/02   Debbie Mao
   02/02   Debbie Mao
   06/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "SciencePMCChannel.h"
#include "DiagnosticReporter.h"

int const science_pmc_channel::PMC_STROKE_SIZE = 12;

extern diagnostic_reporter diagnosticreporter;

science_pmc_channel :: science_pmc_channel ()
                     : science_channel ()
                     , science_pmc_signal ()
{
  ;
}


science_pmc_channel :: science_pmc_channel (int channelnumber)
                     : science_channel (channelnumber)
                     , science_pmc_signal ()
{
  ;
}


science_pmc_channel :: science_pmc_channel (int channelnumber, int mincount, int saturatecount)
                     : science_channel (channelnumber, mincount, (saturatecount - 1))
                     , science_pmc_signal ()
{
  ;
}


science_pmc_channel :: ~science_pmc_channel ()
{
  ;
}


void science_pmc_channel :: GetSignal (double signals [SCIENCE_PIXELS][PMC_SIGNAL_TERMS], 
                                       bool isvalid [SCIENCE_PIXELS]) const
{
  double openvariance [PMC_STROKES] = {0.0, 0.0};
  double closedvariance [PMC_STROKES] = {0.0, 0.0};

  // for each pixel
  for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {
    
    // if any detectors are out of range, set the isvalid flag to false
    if (! PixelWithinRange (pixel))
      isvalid [pixel] = false;
    else {

      // set flag to valid
      isvalid [pixel] = true;

      science_pmc_signal::ComputeSignal (opencounts [pixel], openvariance, closedcounts [pixel], closedvariance,
                                         signals [pixel]);
    }
  }
}


void science_pmc_channel :: GetMeans (double openmeans [SCIENCE_PIXELS] [PMC_STROKES],
                                      double closedmeans [SCIENCE_PIXELS] [PMC_STROKES],
                                      bool isvalid [SCIENCE_PIXELS]) const
{
  for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {

    // if any detectors are out of range, set the isvalid flag to false
    if (! PixelWithinRange (pixel))
      isvalid [pixel] = false;
    else {

      // set flag to valid
      isvalid [pixel] = true;

      // for each stroke, copy the counts
      for (int stroke = 0; stroke < PMC_STROKES; stroke++) {
        openmeans   [pixel] [stroke] = opencounts   [pixel] [stroke];
        closedmeans [pixel] [stroke] = closedcounts [pixel] [stroke];
      }
    }
  }
}



void science_pmc_channel :: Read (bool active, int const pixelmaps [SCIENCE_PIXELS], unsigned char* traindata,
                                  short chopperopensamples, short chopperclosedsamples, short scalefactor,
                                  short choppercycles, processor_parameters const& processorparameters, 
				  mopitt_time const& time)
{
  unsigned char* pixelptr;

  //Get bad granule and bad pixel information
  int badstart[MAX_SCIENCE_GRANULE], badstop[MAX_SCIENCE_GRANULE];
  int badpixel[SCIENCE_CHANNELS][MAX_SCIENCE_GRANULE][SCIENCE_PIXELS];
  mopitt_time traintime = time.GetMsecs ();
  int badgranum = processorparameters.GetBadGranuleNumber ();

  processorparameters.GetBadStartTime ( badstart );
  processorparameters.GetBadStopTime  ( badstop );
  processorparameters.GetBadPixel     ( badpixel );

  // read the header info
  ReadHeader (active, traindata);

  // if the channel is not active, output message and set range flags to false
  if (! active) {
    InvalidateRange ();
    diagnosticreporter.AddEntry (DIAGNOSTICS_STATIC, DIAGNOSTICS_SCIENCE_MODULE, ACTIVE_STATIC, 0, 0, 0, 0, 0, channel,
                                 0, 0, "Inactive channel");
  }
  else {

    // for each pixel
    for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++) {

      // point to the beginning of the pixel's data
      pixelptr = traindata + CHANNEL_HEADER_SIZE + (pixel * PMC_STROKE_SIZE);

      // unload into the correct spot
      int l1pixel = GetL1Pixel (pixel, pixelmaps);

      //validate the pixel
      if ( badgranum != processorparameters.GetBadPixelNumber () ) 
	diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_SCIENCE_MODULE, ACTIVE_STATIC, 0, 0, 0, 0, 0, channel,
                                     0, 0, "Number of granule and the number of pixel not match");	
      int i;
      for ( i=0; i< badgranum; i++ ) 
	if ( traintime >= badstart [i] && traintime <= badstop[i] )
	  break;

      if ( (i < badgranum)  && (badpixel[channel][i][l1pixel] == 1) ) {
	opencounts   [l1pixel] [PMC_LOW_STROKE]   =  SCIENCE_MISSING_INT;
	opencounts   [l1pixel] [PMC_HIGH_STROKE]  =  SCIENCE_MISSING_INT;
	closedcounts [l1pixel] [PMC_LOW_STROKE]   =  SCIENCE_MISSING_INT;
	closedcounts [l1pixel] [PMC_HIGH_STROKE]  =  SCIENCE_MISSING_INT;
	SetInRange (false, l1pixel);
      }
      else if ( channel == 3  && (processorparameters.GetCh7Info() ) == 1 )
	for (int stroke = 0; stroke < PMC_STROKES; stroke++) {
	  opencounts   [l1pixel] [stroke] = 0;
	  closedcounts [l1pixel] [stroke] = 0;
	  SetInRange (false, l1pixel);
	}
      else {
	  
	// unpack the data.  remember to byte-swap
	opencounts   [l1pixel] [PMC_LOW_STROKE]  = 
	                         CheckAndNormalize (l1pixel, chopperopensamples, scalefactor, choppercycles,
			                      ((pixelptr[1] * 65536) + (pixelptr[0]  * 256) + pixelptr[3]));
	opencounts   [l1pixel] [PMC_HIGH_STROKE] = 
	                         CheckAndNormalize (l1pixel, chopperopensamples, scalefactor, choppercycles,
			                     ((pixelptr[2] * 65536) + (pixelptr[5]  * 256) + pixelptr[4]));
	closedcounts [l1pixel] [PMC_LOW_STROKE]  = 
	                         Normalize (chopperclosedsamples, scalefactor, choppercycles,
		                             ((pixelptr[7] * 65536) + (pixelptr[6]  * 256) + pixelptr[9]));
	closedcounts [l1pixel] [PMC_HIGH_STROKE] = 
	                         Normalize (chopperclosedsamples, scalefactor, choppercycles,
					     ((pixelptr[8] * 65536) + (pixelptr[11] * 256) + pixelptr[10]));
      }
    }
  }
}
